/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.CompactionScheduler;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.task.FakedInnerSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InnerCompactionSchedulerTest
extends AbstractCompactionTest {
    private long originFileSize;
    long MAX_WAITING_TIME = 120000L;
    boolean oldEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
    boolean oldEnableUnSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
    int oldConcurrentCompactionThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
    int oldMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        CompactionTaskManager.getInstance().start();
        super.setUp();
        this.originFileSize = IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize();
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(90L);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        CompactionTaskManager.getInstance().stop();
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(this.originFileSize);
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(this.oldEnableSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(this.oldEnableUnSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(this.oldConcurrentCompactionThread);
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(this.oldMaxCompactionCandidateFileNum);
        super.tearDown();
    }

    @Test
    public void testFileSelector1() throws IOException, MetadataException, WriteProcessException {
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(4);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(1000000L);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        this.registerTimeseriesInMManger(3, 5, false);
        this.createFiles(2, 5, 5, 50, 600, 800, 50, 50, false, true);
        this.registerTimeseriesInMManger(5, 5, false);
        TsFileManager tsFileManager = new TsFileManager("testSG", "0", "tmp");
        tsFileManager.addAll(this.seqResources, true);
        CompactionScheduler.tryToSubmitInnerSpaceCompactionTask((String)"testSG", (String)"0", (long)0L, (TsFileManager)tsFileManager, (boolean)true, (InnerSpaceCompactionTaskFactory)new FakedInnerSpaceCompactionTaskFactory());
        CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testFileSelector2() throws IOException, MetadataException, WriteProcessException {
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(50);
        TsFileResourceList tsFileResources = new TsFileResourceList();
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        ((TsFileResource)this.seqResources.get(0)).setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE);
        ((TsFileResource)this.seqResources.get(0)).setStatus(TsFileResourceStatus.COMPACTING);
        TsFileManager tsFileManager = new TsFileManager("testSG", "0", "tmp");
        tsFileManager.addAll(this.seqResources, true);
        CompactionScheduler.tryToSubmitInnerSpaceCompactionTask((String)"testSG", (String)"0", (long)0L, (TsFileManager)tsFileManager, (boolean)true, (InnerSpaceCompactionTaskFactory)new FakedInnerSpaceCompactionTaskFactory());
        CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
        long waitingTime = 0L;
        while (CompactionTaskManager.getInstance().getExecutingTaskCount() != 0) {
            try {
                Thread.sleep(100L);
                if ((waitingTime += 100L) <= this.MAX_WAITING_TIME) continue;
                Assert.fail();
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((long)4L, (long)tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testFileSelectorWithUnclosedFile() throws IOException, MetadataException, WriteProcessException {
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(50);
        TsFileResourceList tsFileResources = new TsFileResourceList();
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        ((TsFileResource)this.seqResources.get(3)).setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileManager tsFileManager = new TsFileManager("testSG", "0", "tmp");
        tsFileManager.addAll(this.seqResources, true);
        CompactionScheduler.tryToSubmitInnerSpaceCompactionTask((String)"testSG", (String)"0", (long)0L, (TsFileManager)tsFileManager, (boolean)true, (InnerSpaceCompactionTaskFactory)new FakedInnerSpaceCompactionTaskFactory());
        CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
        long waitingTime = 0L;
        while (CompactionTaskManager.getInstance().getExecutingTaskCount() != 0) {
            try {
                Thread.sleep(100L);
                if ((waitingTime += 100L) <= this.MAX_WAITING_TIME) continue;
                Assert.fail();
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((long)4L, (long)tsFileManager.getTsFileList(true).size());
    }
}

