/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RewriteCrossSpaceCompactionTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInTimeseries() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s0");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s1");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s4");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s4");
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE, false);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE, false);
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE, true);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        TsFileManager tsFileManager = new TsFileManager(this.COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionTask rewriteCrossSpaceCompactionTask = new RewriteCrossSpaceCompactionTask(this.COMPACTION_TEST_SG, "0", 0L, tsFileManager, this.seqResources, this.unseqResources, new AtomicInteger(0));
        rewriteCrossSpaceCompactionTask.call();
        for (TsFileResource resource : this.seqResources) {
            resource.resetModFile();
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            resource.setFile(new File(resource.getTsFilePath().replace(".cross", ".tsfile")));
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)24L, (long)resource.getModFile().getModifications().size());
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInOneTargetFile() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE, false);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE, false);
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE, true);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE, true);
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        TsFileManager tsFileManager = new TsFileManager(this.COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionTask rewriteCrossSpaceCompactionTask = new RewriteCrossSpaceCompactionTask(this.COMPACTION_TEST_SG, "0", 0L, tsFileManager, this.seqResources, this.unseqResources, new AtomicInteger(0));
        rewriteCrossSpaceCompactionTask.call();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            resource.setFile(new File(resource.getTsFilePath().replace(".cross", ".tsfile")));
            if (!resource.getTsFile().exists()) continue;
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)180L, (long)resource.getModFile().getModifications().size());
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0 || i2 == 1 || i2 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testOneDeletionDuringCompaction() throws Exception {
        VirtualStorageGroupProcessor vsgp = new VirtualStorageGroupProcessor(STORAGE_GROUP_DIR.getPath(), "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), this.COMPACTION_TEST_SG);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        vsgp.getTsFileResourceManager().addAll(this.seqResources, true);
        vsgp.getTsFileResourceManager().addAll(this.unseqResources, false);
        vsgp.delete(new PartialPath(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s0"), 0L, 1000L, 0L, null);
        RewriteCrossSpaceCompactionTask rewriteCrossSpaceCompactionTask = new RewriteCrossSpaceCompactionTask(this.COMPACTION_TEST_SG, "0", 0L, vsgp.getTsFileResourceManager(), this.seqResources, this.unseqResources, new AtomicInteger(0));
        rewriteCrossSpaceCompactionTask.setSourceFilesToCompactionCandidate();
        rewriteCrossSpaceCompactionTask.checkValidAndSetMerging();
        vsgp.delete(new PartialPath(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s0"), 0L, 1200L, 0L, null);
        for (int i = 0; i < this.seqResources.size(); ++i) {
            TsFileResource resource = (TsFileResource)this.seqResources.get(i);
            resource.resetModFile();
            if (i < 2) {
                Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
                Assert.assertFalse((boolean)resource.getModFile().exists());
                continue;
            }
            if (i == 2) {
                Assert.assertTrue((boolean)resource.getCompactionModFile().exists());
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
                Assert.assertEquals((long)1L, (long)resource.getCompactionModFile().getModifications().size());
                continue;
            }
            Assert.assertTrue((boolean)resource.getCompactionModFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
            Assert.assertEquals((long)1L, (long)resource.getCompactionModFile().getModifications().size());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        rewriteCrossSpaceCompactionTask.call();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (int i = 0; i < this.seqResources.size(); ++i) {
            TsFileResource seqResource = (TsFileResource)this.seqResources.get(i);
            TsFileResource resource = new TsFileResource(TsFileNameGenerator.increaseCrossCompactionCnt((File)seqResource.getTsFile()));
            if (i < 2) {
                Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
                Assert.assertFalse((boolean)resource.getModFile().exists());
                continue;
            }
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
    }

    @Test
    public void testSeveralDeletionsDuringCompaction() throws Exception {
        VirtualStorageGroupProcessor vsgp = new VirtualStorageGroupProcessor(STORAGE_GROUP_DIR.getPath(), "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), this.COMPACTION_TEST_SG);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        vsgp.getTsFileResourceManager().addAll(this.seqResources, true);
        vsgp.getTsFileResourceManager().addAll(this.unseqResources, false);
        vsgp.delete(new PartialPath(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s0"), 0L, 1000L, 0L, null);
        RewriteCrossSpaceCompactionTask rewriteCrossSpaceCompactionTask = new RewriteCrossSpaceCompactionTask(this.COMPACTION_TEST_SG, "0", 0L, vsgp.getTsFileResourceManager(), this.seqResources, this.unseqResources, new AtomicInteger(0));
        rewriteCrossSpaceCompactionTask.setSourceFilesToCompactionCandidate();
        rewriteCrossSpaceCompactionTask.checkValidAndSetMerging();
        vsgp.delete(new PartialPath(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s0"), 0L, 1200L, 0L, null);
        vsgp.delete(new PartialPath(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s0"), 0L, 1800L, 0L, null);
        for (int i = 0; i < this.seqResources.size(); ++i) {
            TsFileResource resource = (TsFileResource)this.seqResources.get(i);
            resource.resetModFile();
            if (i < 2) {
                Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
                Assert.assertFalse((boolean)resource.getModFile().exists());
                continue;
            }
            if (i == 2) {
                Assert.assertTrue((boolean)resource.getCompactionModFile().exists());
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)3L, (long)resource.getModFile().getModifications().size());
                Assert.assertEquals((long)2L, (long)resource.getCompactionModFile().getModifications().size());
                continue;
            }
            Assert.assertTrue((boolean)resource.getCompactionModFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
            Assert.assertEquals((long)2L, (long)resource.getCompactionModFile().getModifications().size());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        rewriteCrossSpaceCompactionTask.call();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (int i = 0; i < this.seqResources.size(); ++i) {
            TsFileResource seqResource = (TsFileResource)this.seqResources.get(i);
            TsFileResource resource = new TsFileResource(TsFileNameGenerator.increaseCrossCompactionCnt((File)seqResource.getTsFile()));
            if (i < 2) {
                Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
                Assert.assertFalse((boolean)resource.getModFile().exists());
                continue;
            }
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
        }
    }

    private void generateModsFile(List<String> seriesPaths, List<TsFileResource> resources, long startValue, long endValue, boolean isCompactionMods) throws IllegalPathException, IOException {
        for (TsFileResource resource : resources) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (String path : seriesPaths) {
                deleteMap.put(path, (Pair<Long, Long>)new Pair((Object)startValue, (Object)endValue));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, isCompactionMods);
        }
    }
}

