/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.cross.MergeTest;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class RewriteCompactionFileSelectorTest
extends MergeTest {
    @Test
    public void testFullSelection() throws MergeException, IOException {
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals((Object)this.seqResources, (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        resource.clear();
        resource = new CrossSpaceCompactionResource(this.seqResources.subList(0, 1), this.unseqResources);
        mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        resource.clear();
        resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources.subList(0, 1));
        mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 1), (Object)unseqSelected);
        resource.clear();
    }

    @Test
    public void testNonSelection() throws MergeException, IOException {
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 1L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        resource.clear();
    }

    @Test
    public void testRestrictedSelection() throws MergeException, IOException {
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 400000L);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 4), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 4), (Object)unseqSelected);
        resource.clear();
    }

    @Test
    public void testFileOpenSelection() throws MergeException, IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setStatus(TsFileResourceStatus.UNCLOSED);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (String device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, newUnseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)0L, (long)result.length);
        resource.clear();
    }

    @Test
    public void testFileOpenSelectionFromCompaction() throws IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setStatus(TsFileResourceStatus.UNCLOSED);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (String device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        long ttlLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionResource mergeResource = new CrossSpaceCompactionResource((Collection)this.seqResources, newUnseqResources, ttlLowerBound);
        Assert.assertEquals((long)5L, (long)mergeResource.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)mergeResource.getUnseqFiles().size());
        mergeResource.clear();
    }

    @Test
    public void testFileSelectionAboutLastSeqFile() throws MergeException, IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        largeUnseqTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, this.ptNum + 1L, 0L);
        this.unseqResources.clear();
        this.unseqResources.add(largeUnseqTsFileResource);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result[0].size());
        resource.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectContinuousUnseqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        try {
            int seqFileNum = 99;
            for (int i = 0; i < seqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setStatus(TsFileResourceStatus.CLOSED);
                this.prepareFile(fileResource, i, 1L, 0L);
                seqList.add(fileResource);
            }
            int unseqFileNum = 3;
            for (int i = 0; i < unseqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setStatus(TsFileResourceStatus.CLOSED);
                unseqList.add(fileResource);
            }
            this.prepareFile((TsFileResource)unseqList.get(0), 0L, 1L, 10L);
            this.prepareFile((TsFileResource)unseqList.get(1), 0L, 100L, 20L);
            this.prepareFile((TsFileResource)unseqList.get(2), 99L, 1L, 30L);
            CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
            RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 29000L);
            List[] result = mergeFileSelector.select();
            Assert.assertEquals((long)1L, (long)result[0].size());
            Assert.assertEquals((long)1L, (long)result[1].size());
            Assert.assertEquals(seqList.get(0), result[0].get(0));
            Assert.assertEquals(unseqList.get(0), result[1].get(0));
            resource.clear();
            resource = new CrossSpaceCompactionResource(seqList.subList(1, seqList.size()), unseqList.subList(1, unseqList.size()));
            mergeFileSelector = new RewriteCompactionFileSelector(resource, 29000L);
            result = mergeFileSelector.select();
            Assert.assertEquals((long)2L, (long)result.length);
            resource.clear();
        }
        finally {
            this.removeFiles(seqList, unseqList);
        }
    }

    @Test
    public void testUnseqFilesOverlappedWithOneSeqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 10;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 1L, i);
            unseqList.add(fileResource);
        }
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)10L, (long)resource.getUnseqFiles().size());
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 524288000L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].size());
        Assert.assertEquals((long)10L, (long)result[1].size());
    }

    @Test
    public void testOneUnseqFileOverlappedWithOneSeqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 1;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 10L, i);
            unseqList.add(fileResource);
        }
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)resource.getUnseqFiles().size());
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 524288000L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
    }

    @Test
    public void testUnseqFilesOverlapped() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 2;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)resource.getUnseqFiles().size());
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 524288000L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
    }

    @Test
    public void testAllUnseqFilesOverlapped() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 4;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        this.prepareFile((TsFileResource)unseqList.get(2), 14L, 3L, 14L);
        this.prepareFile((TsFileResource)unseqList.get(3), 17L, 2L, 17L);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)resource.getUnseqFiles().size());
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 524288000L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)4L, (long)result[1].size());
    }

    @Test
    public void testAllUnseqFilesOverlappedWithSeqFileOpen() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            if (i - 11 != 3) {
                fileResource.setStatus(TsFileResourceStatus.CLOSED);
            }
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 4;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        this.prepareFile((TsFileResource)unseqList.get(2), 14L, 3L, 14L);
        this.prepareFile((TsFileResource)unseqList.get(3), 17L, 2L, 17L);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)resource.getUnseqFiles().size());
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, 524288000L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
    }

    @Test
    public void testMultiFileOverlapWithOneFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        File firstFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("1-1-0-0.tsfile"));
        TsFileResource firstTsFileResource = new TsFileResource(firstFile);
        firstTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        firstTsFileResource.setMinPlanIndex(1L);
        firstTsFileResource.setMaxPlanIndex(1L);
        firstTsFileResource.setVersion(1L);
        seqList.add(firstTsFileResource);
        if (!firstFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)firstFile.getParentFile().mkdirs());
        }
        TsFileWriter fileWriter = new TsFileWriter(firstFile);
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 0L; i < 10L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                if (j == 3 && i > 5L) continue;
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                firstTsFileResource.updateStartTime(this.deviceIds[j], i);
                firstTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File secondFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("2-2-0-0.tsfile"));
        TsFileResource secondTsFileResource = new TsFileResource(secondFile);
        secondTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        secondTsFileResource.setMinPlanIndex(2L);
        secondTsFileResource.setMaxPlanIndex(2L);
        secondTsFileResource.setVersion(2L);
        seqList.add(secondTsFileResource);
        if (!secondFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)secondFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(secondFile);
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 11L; i < 21L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                secondTsFileResource.updateStartTime(this.deviceIds[j], i);
                secondTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File thirdFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("3-3-0-0.tsfile"));
        TsFileResource thirdTsFileResource = new TsFileResource(thirdFile);
        thirdTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        thirdTsFileResource.setMinPlanIndex(3L);
        thirdTsFileResource.setMaxPlanIndex(3L);
        thirdTsFileResource.setVersion(3L);
        unseqList.add(thirdTsFileResource);
        if (!secondFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)thirdFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(thirdFile);
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 0L; i < 2L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                thirdTsFileResource.updateStartTime(this.deviceIds[j], i);
                thirdTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File fourthFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("4-4-0-0.tsfile"));
        TsFileResource fourthTsFileResource = new TsFileResource(fourthFile);
        fourthTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        fourthTsFileResource.setMinPlanIndex(4L);
        fourthTsFileResource.setMaxPlanIndex(4L);
        fourthTsFileResource.setVersion(4L);
        unseqList.add(fourthTsFileResource);
        if (!fourthFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)fourthFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(fourthFile);
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 6L; i < 15L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                if (j == 3) continue;
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                fourthTsFileResource.updateStartTime(this.deviceIds[j], i);
                fourthTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        TSRecord record = new TSRecord(1L, this.deviceIds[3]);
        for (int k = 0; k < this.measurementNum; ++k) {
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(1)));
        }
        fileWriter.write(record);
        fourthTsFileResource.updateStartTime(this.deviceIds[3], 1L);
        fourthTsFileResource.updateEndTime(this.deviceIds[3], 1L);
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        CrossSpaceCompactionResource compactionResource = new CrossSpaceCompactionResource(seqList, unseqList);
        RewriteCompactionFileSelector selector = new RewriteCompactionFileSelector(compactionResource, 524288000L);
        List[] result = selector.select();
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
    }

    @Test
    public void testMaxFileSelection() throws MergeException, IOException {
        int oldMaxCrossCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(5);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals((long)2L, (long)seqSelected.size());
        Assert.assertEquals((long)2L, (long)unseqSelected.size());
        resource.clear();
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(oldMaxCrossCompactionCandidateFileNum);
    }

    @Test
    public void testAtLeastOneUnseqFileBeenSelected() throws IOException, MergeException {
        int maxCrossFilesNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(1);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals((long)1L, (long)seqSelected.size());
        Assert.assertEquals((long)1L, (long)unseqSelected.size());
        resource.clear();
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(maxCrossFilesNum);
    }
}

