/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.tools.validate.TsFileValidationTool;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionValidationTest
extends AbstractCompactionTest {
    TsFileManager tsFileManager;
    private final String oldThreadName;

    public CrossSpaceCompactionValidationTest() {
        this.tsFileManager = new TsFileManager(this.COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());
        this.oldThreadName = Thread.currentThread().getName();
    }

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }

    @Test
    public void test1() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test2() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test3() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test4() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6500, 6500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6301, 6301, 100, 100, true, false);
        ((TsFileResource)this.seqResources.get(4)).setStatus(TsFileResourceStatus.UNCLOSED);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)4L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        Assert.assertEquals(result[1].get(2), this.unseqResources.get(2));
        Assert.assertEquals(result[1].get(3), this.unseqResources.get(3));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test5() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(7);
        this.createFiles(7, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4400, 1150, 1150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(5));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test6() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].size());
        Assert.assertEquals((long)3L, (long)result[1].size());
        for (TsFileResource selectedResource : result[0]) {
            Assert.assertEquals((Object)selectedResource, this.seqResources.get(1));
        }
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        Assert.assertEquals(result[1].get(2), this.unseqResources.get(2));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test7() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(3, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4050, 1200, 1200, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)4L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        Assert.assertEquals(result[1].get(2), this.unseqResources.get(2));
        Assert.assertEquals(result[1].get(3), this.unseqResources.get(3));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void test8() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)4L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        Assert.assertEquals(result[1].get(2), this.unseqResources.get(2));
        Assert.assertEquals(result[1].get(3), this.unseqResources.get(3));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile10() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile11() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile12() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile20() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile21() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile22() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile30() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile31() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile32() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile50() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile51() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile52() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)6L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[0].get(5), this.seqResources.get(7));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile53() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(7));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile10() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile11() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile12() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile20() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile21() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile22() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile30() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile31() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile32() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)3L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(1));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile50() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile51() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile52() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)6L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(6));
        Assert.assertEquals(result[0].get(5), this.seqResources.get(7));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile53() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)5L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[0].get(2), this.seqResources.get(4));
        Assert.assertEquals(result[0].get(3), this.seqResources.get(5));
        Assert.assertEquals(result[0].get(4), this.seqResources.get(7));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithUnclosedSeqFile() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithUnclosedSeqFileAndNewSensorInUnseqFile() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(3, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile2() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 50, 4310, 4310, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)2L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        Assert.assertEquals(result[1].get(1), this.unseqResources.get(1));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    @Test
    public void testWithUnclosedUnSeqFile() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedUnSeqResource = new TsFileResource(((TsFileResource)this.unseqResources.get(1)).getTsFile());
        unclosedUnSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastUnSeqResource = (TsFileResource)this.unseqResources.get(1);
        for (String deviceID : lastUnSeqResource.getDevices()) {
            unclosedUnSeqResource.updateStartTime(deviceID, lastUnSeqResource.getStartTime(deviceID));
            unclosedUnSeqResource.updateEndTime(deviceID, lastUnSeqResource.getEndTime(deviceID));
        }
        this.unseqResources.remove(1);
        this.unseqResources.add(1, unclosedUnSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCompactionFileSelector mergeFileSelector = new RewriteCompactionFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((long)2L, (long)result[0].size());
        Assert.assertEquals((long)1L, (long)result[1].size());
        Assert.assertEquals(result[0].get(0), this.seqResources.get(2));
        Assert.assertEquals(result[0].get(1), this.seqResources.get(3));
        Assert.assertEquals(result[1].get(0), this.unseqResources.get(0));
        new RewriteCrossSpaceCompactionTask("0", this.COMPACTION_TEST_SG, 0L, this.tsFileManager, result[0], result[1], new AtomicInteger(0)).call();
        this.validateSeqFiles();
    }

    private void validateSeqFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
            files.add(resource.getTsFile());
        }
        TsFileValidationTool.findUncorrectFiles(files);
        Assert.assertEquals((long)0L, (long)TsFileValidationTool.badFileNum);
    }
}

