/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionClearUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionTimeseriesType;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();
    int index = 0;
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    static final String[] fullPaths = new String[]{"root.compactionTest.device0.sensor0", "root.compactionTest.device0.sensor1", "root.compactionTest.device0.sensor2", "root.compactionTest.device0.sensor3", "root.compactionTest.device0.sensor4", "root.compactionTest.device0.sensor5", "root.compactionTest.device0.sensor6", "root.compactionTest.device0.sensor7", "root.compactionTest.device0.sensor8", "root.compactionTest.device0.sensor9", "root.compactionTest.device1.sensor0", "root.compactionTest.device1.sensor1", "root.compactionTest.device1.sensor2", "root.compactionTest.device1.sensor3", "root.compactionTest.device1.sensor4"};
    static final CompactionTimeseriesType[] compactionTimeseriesTypes = new CompactionTimeseriesType[]{CompactionTimeseriesType.ALL_SAME, CompactionTimeseriesType.PART_SAME, CompactionTimeseriesType.NO_SAME};
    static final boolean[] compactionBeforeHasMods = new boolean[]{true, false};
    static final boolean[] compactionHasMods = new boolean[]{true, false};

    @Before
    public void setUp() throws MetadataException {
        IoTDB.metaManager.init();
        IoTDB.metaManager.setStorageGroup(new PartialPath(COMPACTION_TEST_SG));
        for (String fullPath : fullPaths) {
            PartialPath path = new PartialPath(fullPath);
            IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
        CompactionTaskManager.getInstance().start();
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        CompactionClearUtils.clearAllCompactionFiles();
        CompactionClearUtils.deleteEmptyDir(new File("target"));
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.metaManager.clear();
        CompactionTaskManager.getInstance().stop();
        EnvironmentUtils.cleanAllDir();
        Thread.currentThread().setName(this.oldThreadName);
        new CompactionConfigRestorer().restoreCompactionConfig();
    }

    @Test
    public void testOneSeqFileAndSixUnseqFile() throws Exception {
        for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
            for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                for (boolean compactionHasMod : compactionHasMods) {
                    HashSet<String> fullPath;
                    ArrayList<TsFileResource> seqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[14]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[14]);
                    }
                    ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                    ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 2000L, tsFileResource);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)2000L, (Object)2500L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                    }
                    seqResources.add(tsFileResource);
                    ArrayList<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile1 = CompactionFileGeneratorUtils.generateTsFileResource(false, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3000L, unseqFile1);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)3000L, (Object)3100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile1, false);
                    }
                    unseqResources.add(unseqFile1);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[2]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(2000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(2000L);
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile2 = CompactionFileGeneratorUtils.generateTsFileResource(false, 2, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 1000L, unseqFile2);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[2], new Pair((Object)1000L, (Object)1100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile2, false);
                    }
                    unseqResources.add(unseqFile2);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile3 = CompactionFileGeneratorUtils.generateTsFileResource(false, 3, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 1000L, unseqFile3);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[3], new Pair((Object)1100L, (Object)1200L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile3, false);
                    }
                    unseqResources.add(unseqFile3);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile4 = CompactionFileGeneratorUtils.generateTsFileResource(false, 4, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3000L, unseqFile4);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[4], new Pair((Object)3100L, (Object)3200L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile4, false);
                    }
                    unseqResources.add(unseqFile4);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                        fullPath.add(fullPaths[12]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile5 = CompactionFileGeneratorUtils.generateTsFileResource(false, 5, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 0L, unseqFile5);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[5], new Pair((Object)0L, (Object)100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile5, false);
                    }
                    unseqResources.add(unseqFile5);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                        fullPath.add(fullPaths[12]);
                        fullPath.add(fullPaths[13]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[6]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource unseqFile6 = CompactionFileGeneratorUtils.generateTsFileResource(false, 6, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 5000L, unseqFile6);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[5], new Pair((Object)5000L, (Object)5100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, unseqFile5, false);
                    }
                    unseqResources.add(unseqFile6);
                    ArrayList<TsFileResource> sourceResources = new ArrayList<TsFileResource>(seqResources);
                    sourceResources.addAll(unseqResources);
                    Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(sourceResources);
                    if (compactionHasMod) {
                        HashMap<String, Object> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)250L, (Object)300L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)seqResources.get(0), true);
                        toDeleteTimeseriesAndTime = new HashMap();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], (Pair<Long, Long>)new Pair((Object)0L, (Object)100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)unseqResources.get(5), true);
                        List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 250L && timeValuePair.getTimestamp() <= 300L);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 0L && timeValuePair.getTimestamp() <= 100L);
                    }
                    TsFileResourceList seqTsFileResourceList = new TsFileResourceList();
                    seqTsFileResourceList.addAll(seqResources);
                    TsFileResourceList unseqTsFileResourceList = new TsFileResourceList();
                    unseqTsFileResourceList.addAll(unseqResources);
                    long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
                    CrossSpaceCompactionResource mergeResource = new CrossSpaceCompactionResource((Collection)seqTsFileResourceList, (List)unseqTsFileResourceList, timeLowerBound);
                    RewriteCompactionFileSelector fileSelector = new RewriteCompactionFileSelector(mergeResource, Long.MAX_VALUE);
                    List[] mergeFiles = fileSelector.select();
                    mergeResource.clear();
                    ++this.index;
                    if (mergeFiles.length > 0) {
                        CrossSpaceCompactionTaskFactory taskFactory = new CrossSpaceCompactionTaskFactory();
                        AbstractCompactionTask compactionTask = taskFactory.createTask(COMPACTION_TEST_SG, "0", 0L, new TsFileManager(COMPACTION_TEST_SG, "0", "target\\data\\sequence\\test\\root.compactionTest\\0\\0\\"), mergeResource.getSeqFiles(), mergeResource.getUnseqFiles());
                        compactionTask.call();
                        ArrayList<TsFileResource> targetTsfileResourceList = new ArrayList<TsFileResource>();
                        for (TsFileResource seqResource : seqResources) {
                            TsFileResource targetResource = new TsFileResource(TsFileNameGenerator.increaseCrossCompactionCnt((TsFileResource)seqResource).getTsFile());
                            targetResource.deserialize();
                            targetResource.setStatus(TsFileResourceStatus.CLOSED);
                            targetTsfileResourceList.add(targetResource);
                        }
                        CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsfileResourceList);
                        CompactionClearUtils.clearAllCompactionFiles();
                        continue;
                    }
                    Assert.fail();
                }
            }
        }
    }

    @Test
    public void testFiveSeqFileAndOneUnseqFileWithSomeDeviceNotInSeqFiles() throws Exception {
        for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
            for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                for (boolean compactionHasMod : compactionHasMods) {
                    HashSet<String> fullPath;
                    ArrayList<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                    }
                    ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                    ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 2000L, tsFileResource);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)2000L, (Object)2500L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                    }
                    unseqResources.add(tsFileResource);
                    ArrayList<TsFileResource> seqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[2]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile1 = CompactionFileGeneratorUtils.generateTsFileResource(true, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 0L, seqFile1);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)0L, (Object)25L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile1, false);
                    }
                    seqResources.add(seqFile1);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[14]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[14]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile2 = CompactionFileGeneratorUtils.generateTsFileResource(true, 2, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 1000L, seqFile2);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)3000L, (Object)3100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile2, false);
                    }
                    seqResources.add(seqFile2);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile3 = CompactionFileGeneratorUtils.generateTsFileResource(true, 3, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3500L, seqFile3);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[3], new Pair((Object)3500L, (Object)3525L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile3, false);
                    }
                    seqResources.add(seqFile3);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile4 = CompactionFileGeneratorUtils.generateTsFileResource(true, 4, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3750L, seqFile4);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[4], new Pair((Object)3800L, (Object)3900L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile4, false);
                    }
                    seqResources.add(seqFile4);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                        fullPath.add(fullPaths[12]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile5 = CompactionFileGeneratorUtils.generateTsFileResource(true, 5, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 6250L, seqFile5);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[5], new Pair((Object)6300L, (Object)6400L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile5, false);
                    }
                    seqResources.add(seqFile5);
                    ArrayList<TsFileResource> sourceResources = new ArrayList<TsFileResource>(unseqResources);
                    for (int i = 1; i < 4; ++i) {
                        sourceResources.add((TsFileResource)seqResources.get(i));
                    }
                    Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(sourceResources);
                    if (compactionHasMod) {
                        HashMap<String, Object> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)2500L, (Object)2600L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)unseqResources.get(0), true);
                        toDeleteTimeseriesAndTime = new HashMap();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], (Pair<Long, Long>)new Pair((Object)0L, (Object)100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)seqResources.get(0), true);
                        List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 2500L && timeValuePair.getTimestamp() <= 2600L);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 0L && timeValuePair.getTimestamp() <= 100L);
                    }
                    TsFileResourceList seqTsFileResourceList = new TsFileResourceList();
                    seqTsFileResourceList.addAll(seqResources);
                    TsFileResourceList unseqTsFileResourceList = new TsFileResourceList();
                    unseqTsFileResourceList.addAll(unseqResources);
                    long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
                    CrossSpaceCompactionResource mergeResource = new CrossSpaceCompactionResource((Collection)seqTsFileResourceList, (List)unseqTsFileResourceList, timeLowerBound);
                    RewriteCompactionFileSelector fileSelector = new RewriteCompactionFileSelector(mergeResource, Long.MAX_VALUE);
                    List[] mergeFiles = fileSelector.select();
                    mergeResource.clear();
                    if (mergeFiles.length > 0) {
                        CrossSpaceCompactionTaskFactory taskFactory = new CrossSpaceCompactionTaskFactory();
                        AbstractCompactionTask compactionTask = taskFactory.createTask(COMPACTION_TEST_SG, "0", 0L, new TsFileManager(COMPACTION_TEST_SG, "0", "target\\data\\sequence\\test\\root.compactionTest\\0\\0\\"), mergeResource.getSeqFiles(), mergeResource.getUnseqFiles());
                        compactionTask.call();
                        ArrayList<TsFileResource> targetTsfileResourceList = new ArrayList<TsFileResource>();
                        for (TsFileResource seqResource : seqResources.subList(1, 4)) {
                            TsFileResource targetResource = new TsFileResource(TsFileNameGenerator.increaseCrossCompactionCnt((TsFileResource)seqResource).getTsFile());
                            targetResource.deserialize();
                            targetResource.setStatus(TsFileResourceStatus.CLOSED);
                            targetTsfileResourceList.add(targetResource);
                        }
                        CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsfileResourceList);
                        CompactionClearUtils.clearAllCompactionFiles();
                        continue;
                    }
                    Assert.fail();
                }
            }
        }
    }

    @Test
    public void testFiveSeqFileAndOneUnseqFile() throws Exception {
        for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
            for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                for (boolean compactionHasMod : compactionHasMods) {
                    HashSet<String> fullPath;
                    ArrayList<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                    }
                    ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                    ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 2000L, tsFileResource);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)2000L, (Object)2500L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                    }
                    unseqResources.add(tsFileResource);
                    ArrayList<TsFileResource> seqResources = new ArrayList<TsFileResource>();
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[14]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[0]);
                        fullPath.add(fullPaths[14]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile1 = CompactionFileGeneratorUtils.generateTsFileResource(true, 1, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 0L, seqFile1);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)0L, (Object)25L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile1, false);
                    }
                    seqResources.add(seqFile1);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[2]);
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[1]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile2 = CompactionFileGeneratorUtils.generateTsFileResource(true, 2, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 1000L, seqFile2);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)3000L, (Object)3100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile2, false);
                    }
                    seqResources.add(seqFile2);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[3]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(100L);
                    pagePointsNum.add(50L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile3 = CompactionFileGeneratorUtils.generateTsFileResource(true, 3, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3500L, seqFile3);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[3], new Pair((Object)3500L, (Object)3525L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile3, false);
                    }
                    seqResources.add(seqFile3);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[4]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile4 = CompactionFileGeneratorUtils.generateTsFileResource(true, 4, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 3750L, seqFile4);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[4], new Pair((Object)3800L, (Object)3900L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile4, false);
                    }
                    seqResources.add(seqFile4);
                    if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                        fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                    } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                        fullPath.add(fullPaths[6]);
                        fullPath.add(fullPaths[7]);
                        fullPath.add(fullPaths[8]);
                        fullPath.add(fullPaths[9]);
                        fullPath.add(fullPaths[10]);
                        fullPath.add(fullPaths[11]);
                        fullPath.add(fullPaths[12]);
                    } else {
                        fullPath = new HashSet();
                        fullPath.add(fullPaths[5]);
                    }
                    chunkPagePointsNum = new ArrayList();
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    chunkPagePointsNum.add(pagePointsNum);
                    pagePointsNum = new ArrayList();
                    pagePointsNum.add(1000L);
                    pagePointsNum.add(500L);
                    chunkPagePointsNum.add(pagePointsNum);
                    TsFileResource seqFile5 = CompactionFileGeneratorUtils.generateTsFileResource(true, 5, COMPACTION_TEST_SG);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 6250L, seqFile5);
                    if (compactionBeforeHasMod) {
                        HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[5], new Pair((Object)6300L, (Object)6400L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, seqFile5, false);
                    }
                    seqResources.add(seqFile5);
                    ArrayList<TsFileResource> sourceResources = new ArrayList<TsFileResource>(unseqResources);
                    for (int i = 1; i < 4; ++i) {
                        sourceResources.add((TsFileResource)seqResources.get(i));
                    }
                    Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(sourceResources);
                    if (compactionHasMod) {
                        HashMap<String, Object> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)2500L, (Object)2600L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)unseqResources.get(0), true);
                        toDeleteTimeseriesAndTime = new HashMap();
                        toDeleteTimeseriesAndTime.put(fullPaths[1], (Pair<Long, Long>)new Pair((Object)0L, (Object)100L));
                        CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)seqResources.get(0), true);
                        List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 2500L && timeValuePair.getTimestamp() <= 2600L);
                        timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 0L && timeValuePair.getTimestamp() <= 100L);
                    }
                    TsFileResourceList seqTsFileResourceList = new TsFileResourceList();
                    seqTsFileResourceList.addAll(seqResources);
                    TsFileResourceList unseqTsFileResourceList = new TsFileResourceList();
                    unseqTsFileResourceList.addAll(unseqResources);
                    long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
                    CrossSpaceCompactionResource mergeResource = new CrossSpaceCompactionResource((Collection)seqTsFileResourceList, (List)unseqTsFileResourceList, timeLowerBound);
                    RewriteCompactionFileSelector fileSelector = new RewriteCompactionFileSelector(mergeResource, Long.MAX_VALUE);
                    List[] mergeFiles = fileSelector.select();
                    mergeResource.clear();
                    if (mergeFiles.length > 0) {
                        CrossSpaceCompactionTaskFactory taskFactory = new CrossSpaceCompactionTaskFactory();
                        AbstractCompactionTask compactionTask = taskFactory.createTask(COMPACTION_TEST_SG, "0", 0L, new TsFileManager(COMPACTION_TEST_SG, "0", "target\\data\\sequence\\test\\root.compactionTest\\0\\0\\"), mergeResource.getSeqFiles(), mergeResource.getUnseqFiles());
                        compactionTask.call();
                        ArrayList<TsFileResource> targetTsfileResourceList = new ArrayList<TsFileResource>();
                        for (TsFileResource seqResource : seqResources.subList(1, 4)) {
                            TsFileResource targetResource = new TsFileResource(TsFileNameGenerator.increaseCrossCompactionCnt((TsFileResource)seqResource).getTsFile());
                            targetResource.deserialize();
                            targetResource.setStatus(TsFileResourceStatus.CLOSED);
                            targetTsfileResourceList.add(targetResource);
                        }
                        CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsfileResourceList);
                        CompactionClearUtils.clearAllCompactionFiles();
                        continue;
                    }
                    Assert.fail();
                }
            }
        }
    }
}

