/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionUtilsTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void testSeqInnerSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, false, true);
        MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d1", "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testSeqInnerSpaceCompactionWithDifferentTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        this.registerTimeseriesInMManger(5, 5, false);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        this.createFiles(2, 5, 6, 50, 600, 800, 50, 50, false, true);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        Assert.assertEquals((long)0L, (long)targetResources.get(0).getStartTime(this.COMPACTION_TEST_SG + '.' + "d0"));
        Assert.assertEquals((long)0L, (long)targetResources.get(0).getStartTime(this.COMPACTION_TEST_SG + '.' + "d1"));
        Assert.assertEquals((long)250L, (long)targetResources.get(0).getStartTime(this.COMPACTION_TEST_SG + '.' + "d2"));
        Assert.assertEquals((long)600L, (long)targetResources.get(0).getStartTime(this.COMPACTION_TEST_SG + '.' + "d3"));
        Assert.assertEquals((long)600L, (long)targetResources.get(0).getStartTime(this.COMPACTION_TEST_SG + '.' + "d4"));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((long)749L, (long)targetResources.get(0).getEndTime(this.COMPACTION_TEST_SG + '.' + "d" + i));
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i >= 5 || j >= 5) continue;
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, false, false);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s1", (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s1", (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithDifferentTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(9, 9, false);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, false);
        this.createFiles(2, 3, 5, 50, 150, 150, 50, 50, false, false);
        this.createFiles(2, 5, 5, 50, 100, 100, 100, 100, false, false);
        this.createFiles(2, 7, 7, 70, 200, 300, 100, 100, false, false);
        this.createFiles(2, 9, 9, 70, 100, 300, 100, 100, false, false);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (100L <= batchData.currentTime() && batchData.currentTime() < 170L || 270L <= batchData.currentTime() && batchData.currentTime() < 340L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        } else if (200L <= batchData.currentTime() && batchData.currentTime() < 270L || 370L <= batchData.currentTime() && batchData.currentTime() < 440L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)410L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)310L, (long)count);
                    continue;
                }
                if (i < 5 && j < 5) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                if (i < 7 && j < 7) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)140L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (100L <= batchData.currentTime() && batchData.currentTime() < 170L || 270L <= batchData.currentTime() && batchData.currentTime() < 340L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        } else if (200L <= batchData.currentTime() && batchData.currentTime() < 270L || 370L <= batchData.currentTime() && batchData.currentTime() < 440L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)410L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)310L, (long)count);
                    continue;
                }
                if (i < 5 && j < 5) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                if (i < 7 && j < 7) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)140L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s0", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s1", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + 2 + '.' + "s4", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + 3 + '.' + "s5", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 && j == 0 || i == 0 && j == 1 || i == 2 && j == 4 || i == 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0 && j == 0 || i2 == 0 && j == 1 || i2 == 2 && j == 4 || i2 == 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInDevice() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int j = 0; j < 7; ++j) {
                deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInTargetFile() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int d = 0; d < 5; ++d) {
                for (int j = 0; j < 7; ++j) {
                    deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                }
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)0L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithDifferentTimeseriesAndEmptyPage() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(50);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, true, true);
        this.createFiles(2, 5, 8, 50, 600, 800, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithDifferentTimeseriesAndEmptyChunk() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, true, true);
        this.createFiles(2, 5, 7, 50, 600, 800, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, false);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithEmptyChunkAndEmptyPage() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithAllDataDeletedInTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s0", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s1", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s4", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s5", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithAllDataDeletedInDevice() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int j = 0; j < 7; ++j) {
                deleteMap.put(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (batchData.currentTime() < 200L || batchData.currentTime() < 550L && batchData.currentTime() >= 500L) {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (batchData.currentTime() < 850L) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 100L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(batchData.currentTime() + 200L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.unseqResources, false);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, new ArrayList(), targetResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 0, 0, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d1", "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                if (batchData.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                } else {
                    Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                }
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                if (batchData.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                } else {
                    Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                }
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d0");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if ((Long)measurementMaxTime.get(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= batchData.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, batchData.currentTime());
                        if (i3 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i3 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s0");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s1");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s4");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d3" + '.' + "s4");
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0 && j == 0 || i2 == 0 && j == 1 || i2 == 2 && j == 4 || i2 == 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d0");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if ((Long)measurementMaxTime.get(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= batchData.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, batchData.currentTime());
                        if (i3 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i3 == 0 && j == 0 || i3 == 0 && j == 1 || i3 == 2 && j == 4 || i3 == 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i3 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInDevice() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        int i2;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i2 = 0; i2 < 5; ++i2) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i2);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i2);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0 || i2 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (i = 2; i < 4; ++i) {
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if ((Long)measurementMaxTime.get(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= batchData.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, batchData.currentTime());
                        if (i3 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i3 == 0 || i3 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInOneTargetFile() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        Assert.assertEquals((long)2L, (long)targetResources.size());
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (int i2 = 0; i2 < 2; ++i2) {
            Assert.assertFalse((boolean)targetResources.get(i2).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertFalse((boolean)targetResources.get(i2).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i2).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i2).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i2), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if ((Long)measurementMaxTime.get(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= batchData.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, batchData.currentTime());
                        if (i3 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i3 == 0 || i3 == 1 || i3 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInDeviceInSeqFiles() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        int i2;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i2 = 0; i2 < 5; ++i2) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i2);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i2);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i2);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 < 1) {
                    if (j < 4) {
                        Assert.assertEquals((long)630L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    if (j < 4) {
                        Assert.assertEquals((long)600L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        Assert.assertEquals((long)4L, (long)targetResources.size());
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d0");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (i = 2; i < 3; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.clear();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
        for (i = 3; i < 4; ++i) {
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
            this.check(targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if ((Long)measurementMaxTime.get(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= batchData.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(this.COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, batchData.currentTime());
                        if (i3 == 0 && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)batchData.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i3 < 1) {
                    if (j < 4) {
                        Assert.assertEquals((long)630L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    if (j < 4) {
                        Assert.assertEquals((long)600L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithSameTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 0, 0, true, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, true, false);
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s1", TSDataType.INT64));
        AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d10000", Collections.singletonList("s1"), schemas);
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                if (batchData.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                } else {
                    Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                }
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            while (batchData.hasCurrent()) {
                if (batchData.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                } else {
                    Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                }
                ++count;
                batchData.next();
            }
        }
        tsFilesReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithDifferentTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInTimeseries() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s0");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s1");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s4");
        seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s4");
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        Assert.assertEquals((long)4L, (long)targetResources.size());
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d10000");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d10001");
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10000"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10001"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10002"));
            Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10003"));
            this.check(targetResources.get(i), deviceIdList);
        }
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d10002");
        deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d10003");
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10000"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10001"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10002"));
            Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d10003"));
            this.check(targetResources.get(i), deviceIdList);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInOneTargetFile() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i2 == 0 || i2 == 1 || i2 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithFileTimeIndexResource() throws IOException, WriteProcessException, MetadataException, StorageEngineException, InterruptedException {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(this.COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (TsFileResource resource : this.seqResources) {
            resource.setTimeIndexType((byte)2);
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.setTimeIndexType((byte)2);
        }
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(this.COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.VECTOR, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    BatchData batchData = tsFilesReader.nextBatch();
                    while (batchData.hasCurrent()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= batchData.currentTime() && batchData.currentTime() < 550L || 550L <= batchData.currentTime() && batchData.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 20000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= batchData.currentTime() && batchData.currentTime() < 220L || 250L <= batchData.currentTime() && batchData.currentTime() < 450L || 480L <= batchData.currentTime() && batchData.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)batchData.currentTime(), (Object)((TsPrimitiveType[])batchData.currentValue())[0].getValue());
                        }
                        ++count;
                        batchData.next();
                    }
                }
                tsFilesReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithNewDeviceInUnseqFile() {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        try {
            int i;
            this.registerTimeseriesInMManger(6, 6, false);
            this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
            this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
            this.createFiles(3, 6, 6, 200, 20, 10020, 30, 30, false, false);
            this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
            List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
            CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
            CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
            Assert.assertEquals((long)4L, (long)targetResources.size());
            ArrayList<String> deviceIdList = new ArrayList<String>();
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d0");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
            for (i = 0; i < 2; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
            for (i = 2; i < 3; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d4");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d5");
            for (i = 3; i < 4; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d4"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d5"));
                this.check(targetResources.get(i), deviceIdList);
            }
        }
        catch (IOException | InterruptedException | StorageEngineException | MetadataException | WriteProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDeviceMaxTimeLaterInUnseqFile() {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        try {
            int i;
            this.registerTimeseriesInMManger(6, 6, false);
            this.createFiles(2, 2, 3, 200, 0, 0, 0, 0, false, true);
            this.createFiles(3, 4, 4, 300, 20, 10020, 0, 0, false, false);
            List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
            CompactionUtils.compact((List)this.seqResources, (List)this.unseqResources, targetResources);
            CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)this.COMPACTION_TEST_SG);
            Assert.assertEquals((long)2L, (long)targetResources.size());
            ArrayList<String> deviceIdList = new ArrayList<String>();
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d0");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d1");
            for (i = 0; i < 1; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d2");
            deviceIdList.add(this.COMPACTION_TEST_SG + '.' + "d3");
            for (i = 1; i < 2; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d0"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d1"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d2"));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist(this.COMPACTION_TEST_SG + '.' + "d3"));
                this.check(targetResources.get(i), deviceIdList);
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    MeasurementPath path = new MeasurementPath(this.COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                    SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, targetResources, new ArrayList(), null, null, true);
                    int count = 0;
                    while (tsFilesReader.hasNextBatch()) {
                        BatchData batchData = tsFilesReader.nextBatch();
                        while (batchData.hasCurrent()) {
                            if (batchData.currentTime() < 20L) {
                                Assert.assertEquals((Object)batchData.currentTime(), (Object)batchData.currentValue());
                            } else {
                                Assert.assertEquals((Object)(batchData.currentTime() + 10000L), (Object)batchData.currentValue());
                            }
                            ++count;
                            batchData.next();
                        }
                    }
                    tsFilesReader.close();
                    if (i < 2 && j < 3) {
                        Assert.assertEquals((long)920L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)900L, (long)count);
                }
            }
        }
        catch (IOException | InterruptedException | StorageEngineException | MetadataException | WriteProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void generateModsFile(List<String> seriesPaths, List<TsFileResource> resources, long startValue, long endValue) throws IllegalPathException, IOException {
        for (TsFileResource resource : resources) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (String path : seriesPaths) {
                deleteMap.put(path, (Pair<Long, Long>)new Pair((Object)startValue, (Object)endValue));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
    }

    public void check(TsFileResource targetResource, List<String> deviceIdList) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(targetResource.getTsFile().getAbsolutePath());){
            byte marker;
            reader.position((long)"TsFile".getBytes().length + 1L);
            block14: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        ChunkHeader header = reader.readChunkHeader(marker);
                        int dataSize = header.getDataSize();
                        reader.position(reader.position() + (long)dataSize);
                        continue block14;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        String deviceID = chunkGroupHeader.getDeviceID();
                        if (deviceIdList.contains(deviceID)) continue block14;
                        Assert.fail((String)("Target file " + targetResource.getTsFile().getPath() + " contains empty chunk group " + deviceID));
                        continue block14;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block14;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
        }
    }
}

