/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.InnerCompactionTest;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManagerTest
extends InnerCompactionTest {
    static final Logger logger = LoggerFactory.getLogger(CompactionTaskManagerTest.class);
    File tempSGDir;
    final long MAX_WAITING_TIME = 120000L;

    @Override
    @Before
    public void setUp() throws Exception {
        this.tempSGDir = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L));
        if (this.tempSGDir.exists()) {
            FileUtils.deleteDirectory((File)this.tempSGDir);
        }
        CompactionTaskManager.getInstance().restart();
        Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws StorageEngineException, IOException {
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedSubmitBeforeExecution() throws Exception {
        logger.warn("testRepeatedSubmitBeforeExecution");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        SizeTieredCompactionTask task1 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        SizeTieredCompactionTask task2 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        ((TsFileResource)this.seqResources.get(0)).readLock();
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        try {
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            Assert.assertTrue((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task1));
            Assert.assertEquals((long)manager.getTotalTaskCount(), (long)1L);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertTrue((boolean)resource.isCompactionCandidate());
            }
            Assert.assertFalse((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
            Assert.assertEquals((long)manager.getTotalTaskCount(), (long)1L);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertTrue((boolean)resource.isCompactionCandidate());
            }
            manager.submitTaskFromTaskQueue();
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        Thread.sleep(5000L);
        Assert.assertEquals((long)0L, (long)manager.getTotalTaskCount());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        long waitingTime = 0L;
        while (manager.getRunningCompactionTaskList().size() > 0) {
            Thread.sleep(50L);
            if ((waitingTime += 50L) % 10000L == 0L) {
                logger.warn("{}", (Object)manager.getRunningCompactionTaskList());
            }
            if (waitingTime <= 120000L) continue;
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedSubmitWhenExecuting() throws Exception {
        logger.warn("testRepeatedSubmitWhenExecuting");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        SizeTieredCompactionTask task1 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        SizeTieredCompactionTask task2 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        ((TsFileResource)this.seqResources.get(0)).readLock();
        try {
            CompactionTaskManager manager = CompactionTaskManager.getInstance();
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            manager.addTaskToWaitingQueue((AbstractCompactionTask)task1);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertTrue((boolean)resource.isCompactionCandidate());
            }
            manager.submitTaskFromTaskQueue();
            Thread.sleep(2000L);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            Assert.assertEquals((long)manager.getExecutingTaskCount(), (long)1L);
            Assert.assertFalse((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        long waitingTime = 0L;
        while (CompactionTaskManager.getInstance().getRunningCompactionTaskList().size() > 0) {
            Thread.sleep(100L);
            if ((waitingTime += 100L) % 10000L == 0L) {
                logger.warn("{}", (Object)CompactionTaskManager.getInstance().getRunningCompactionTaskList());
            }
            if (waitingTime <= 120000L) continue;
            Assert.fail();
        }
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }

    @Test
    public void testRepeatedSubmitAfterExecution() throws Exception {
        logger.warn("testRepeatedSubmitAfterExecution");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        SizeTieredCompactionTask task1 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        SizeTieredCompactionTask task2 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        Assert.assertTrue((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task1));
        manager.submitTaskFromTaskQueue();
        while (manager.getTotalTaskCount() > 0) {
            Thread.sleep(10L);
        }
        ((TsFileResource)this.seqResources.get(0)).readLock();
        Assert.assertTrue((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
        manager.submitTaskFromTaskQueue();
        Assert.assertEquals((long)manager.getExecutingTaskCount(), (long)0L);
        ((TsFileResource)this.seqResources.get(0)).readUnlock();
        long waitingTime = 0L;
        while (manager.getRunningCompactionTaskList().size() > 0) {
            Thread.sleep(100L);
            if ((waitingTime += 100L) % 10000L == 0L) {
                logger.warn("{}", (Object)manager.getRunningCompactionTaskList());
            }
            if (waitingTime <= 120000L) continue;
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveSelfFromRunningList() throws Exception {
        List runningList;
        logger.warn("testRemoveSelfFromRunningList");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        SizeTieredCompactionTask task1 = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        manager.restart();
        ((TsFileResource)this.seqResources.get(0)).readLock();
        try {
            manager.addTaskToWaitingQueue((AbstractCompactionTask)task1);
            manager.submitTaskFromTaskQueue();
            Thread.sleep(5000L);
            runningList = manager.getRunningCompactionTaskList();
            Assert.assertEquals((long)1L, (long)runningList.size());
            Assert.assertTrue((boolean)runningList.contains(task1));
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        Thread.sleep(5000L);
        runningList = manager.getRunningCompactionTaskList();
        Assert.assertEquals((long)0L, (long)runningList.size());
        long waitingTime = 0L;
        while (manager.getRunningCompactionTaskList().size() > 0) {
            Thread.sleep(100L);
            if ((waitingTime += 100L) % 10000L == 0L) {
                logger.warn("{}", (Object)manager.getRunningCompactionTaskList());
            }
            if (waitingTime <= 120000L) continue;
            Assert.fail();
        }
    }

    @Test
    public void testSizeTieredCompactionStatus() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        SizeTieredCompactionTask task = new SizeTieredCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, true, new AtomicInteger(0));
        CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.isCompactionCandidate());
        }
        CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
        Thread.sleep(50L);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }

    @Test
    public void testRewriteCrossCompactionFileStatus() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionTask task = new RewriteCrossSpaceCompactionTask("root.compactionTest", "0", 0L, tsFileManager, this.seqResources, this.unseqResources, new AtomicInteger(0));
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.isCompactionCandidate());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.isCompactionCandidate());
        }
        CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }
}

