/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskComparator;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskComparatorTest {
    private final Logger LOGGER = LoggerFactory.getLogger(CompactionTaskComparatorTest.class);
    private final AtomicInteger taskNum = new AtomicInteger(0);
    private FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue = new FixedPriorityBlockingQueue(1024, (Comparator)new CompactionTaskComparator());
    private TsFileManager tsFileManager = new TsFileManager("fakeSg", "0", "/");

    @Before
    public void setUp() {
        this.compactionTaskQueue.clear();
    }

    @After
    public void tearDown() {
        new CompactionConfigRestorer().restoreCompactionConfig();
    }

    @Test
    public void testFileNumCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileSizeCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j - i + 101));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileCompactCountCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 10; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-%d-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPriorityQueueSizeLimit() {
        int i;
        MinMaxPriorityQueue limitQueue = MinMaxPriorityQueue.orderedBy((Comparator)new CompactionTaskComparator()).maximumSize(50).create();
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 10; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-%d-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
            limitQueue.add((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100 && limitQueue.size() > 0; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)limitQueue.poll();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileVersionCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComparationOfDifferentTaskType() throws InterruptedException {
        AbstractCompactionTask currentTask;
        int i;
        IoTDBDescriptor.getInstance().getConfig().setCompactionPriority(CompactionPriority.INNER_CROSS);
        AbstractCompactionTask[] innerCompactionTasks = new AbstractCompactionTask[100];
        AbstractCompactionTask[] crossCompactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            innerCompactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, true, resources);
        }
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> sequenceResources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            ArrayList<TsFileResource> unsequenceResources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, sequenceResources, unsequenceResources);
        }
        for (i = 0; i < 100; ++i) {
            this.compactionTaskQueue.put((Object)innerCompactionTasks[i]);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == innerCompactionTasks[99 - i] ? 1 : 0) != 0);
        }
        for (i = 0; i < 100; ++i) {
            currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == crossCompactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComparationOfCrossSpaceTask() throws InterruptedException {
        int j;
        ArrayList<TsFileResource> unsequenceResources;
        ArrayList<TsFileResource> sequenceResources;
        int i;
        AbstractCompactionTask[] crossCompactionTasks = new AbstractCompactionTask[200];
        for (i = 0; i < 100; ++i) {
            sequenceResources = new ArrayList<TsFileResource>();
            for (int j2 = 0; j2 < i + 1; ++j2) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j2, i + j2)), j2));
            }
            unsequenceResources = new ArrayList<TsFileResource>();
            for (j = i; j < 100; ++j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, sequenceResources, unsequenceResources);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 100; i < 200; ++i) {
            sequenceResources = new ArrayList();
            for (int j3 = 0; j3 < 101; ++j3) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j3, i + j3)), j3));
            }
            unsequenceResources = new ArrayList();
            for (j = 199; j >= i; --j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, this.taskNum, sequenceResources, unsequenceResources);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 0; i < 200; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == crossCompactionTasks[i] ? 1 : 0) != 0);
        }
    }

    private static class FakedTsFileResource
    extends TsFileResource {
        long tsfileSize = 0L;

        public FakedTsFileResource(File tsfile, long tsfileSize) {
            super(tsfile);
            this.tsfileSize = tsfileSize;
        }

        public long getTsFileSize() {
            return this.tsfileSize;
        }
    }

    private static class FakeCrossSpaceCompactionTask
    extends AbstractCrossSpaceCompactionTask {
        public FakeCrossSpaceCompactionTask(String fullStorageGroupName, long timePartition, TsFileManager tsFileManager, AtomicInteger currentTaskNum, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles) {
            super(fullStorageGroupName, timePartition, currentTaskNum, selectedSequenceFiles, selectedUnsequenceFiles, tsFileManager);
        }

        protected void doCompaction() throws Exception {
        }

        public boolean equalsOtherTask(AbstractCompactionTask other) {
            return false;
        }

        public boolean checkValidAndSetMerging() {
            return true;
        }
    }

    private static class FakedInnerSpaceCompactionTask
    extends AbstractInnerSpaceCompactionTask {
        public FakedInnerSpaceCompactionTask(String storageGroupName, long timePartition, TsFileManager tsFileManager, AtomicInteger currentTaskNum, boolean sequence, List<TsFileResource> selectedTsFileResourceList) {
            super(storageGroupName, timePartition, currentTaskNum, sequence, selectedTsFileResourceList, tsFileManager);
        }

        protected void doCompaction() throws Exception {
        }

        public boolean equalsOtherTask(AbstractCompactionTask other) {
            return false;
        }

        public boolean checkValidAndSetMerging() {
            return true;
        }
    }
}

