/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionScheduler;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.utils.CompactionClearUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionSchedulerTest {
    private static final Logger logger = LoggerFactory.getLogger(CompactionSchedulerTest.class);
    static final String COMPACTION_TEST_SG = "root.compactionSchedulerTest-";
    private static final boolean oldEnableInnerSeqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
    private static final boolean oldEnableInnerUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
    private static final boolean oldEnableCrossCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
    static final long MAX_WAITING_TIME = 60000L;
    static final long SCHEDULE_AGAIN_TIME = 30000L;
    static final String[] fullPaths = new String[]{".device0.sensor0", ".device0.sensor1", ".device0.sensor2", ".device0.sensor3", ".device0.sensor4", ".device0.sensor5", ".device0.sensor6", ".device0.sensor7", ".device0.sensor8", ".device0.sensor9", ".device1.sensor0", ".device1.sensor1", ".device1.sensor2", ".device1.sensor3", ".device1.sensor4"};

    @Before
    public void setUp() throws MetadataException, IOException {
        CompactionClearUtils.clearAllCompactionFiles();
        EnvironmentUtils.cleanAllDir();
        IoTDB.metaManager.init();
        File basicOutputDir = new File(TestConstant.BASE_OUTPUT_PATH);
        IoTDBDescriptor.getInstance().getConfig().setCompactionPriority(CompactionPriority.INNER_CROSS);
        if (!basicOutputDir.exists()) {
            Assert.assertTrue((boolean)basicOutputDir.mkdirs());
        }
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        CompactionTaskManager.getInstance().start();
        while (CompactionTaskManager.getInstance().getExecutingTaskCount() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.metaManager.clear();
        CompactionClearUtils.clearAllCompactionFiles();
        EnvironmentUtils.cleanAllDir();
        CompactionClearUtils.deleteEmptyDir(new File("target"));
        CompactionTaskManager.getInstance().stop();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(oldEnableInnerSeqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(oldEnableInnerUnseqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(oldEnableCrossCompaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test1");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(0x80000000L);
        String sgName = "root.compactionSchedulerTest-test1";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    totalWaitingTime += 100L;
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (totalWaitingTime <= 60000L) continue;
                Assert.fail();
                break;
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test2");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        IoTDBDescriptor.getInstance().getConfig().setCrossCompactionMemoryBudget(0x80000000L);
        String sgName = "root.compactionSchedulerTest-test2";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(10L);
                    if ((totalWaitingTime += 10L) > 60000L) {
                        Assert.fail();
                        break;
                    }
                    if (totalWaitingTime % 10000L == 0L) {
                        logger.warn("sequence file num is {}, unsequence file num is {}", (Object)tsFileManager.getTsFileList(true).size(), (Object)tsFileManager.getTsFileList(false).size());
                    }
                    if (totalWaitingTime % 30000L != 0L) continue;
                    logger.warn("Has waited for {} s, Schedule again", (Object)(totalWaitingTime / 1000L));
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test3() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test3");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        String sgName = "root.compactionSchedulerTest-test3";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)0L, (long)tsFileManager.getTsFileList(false).size());
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    totalWaitingTime += 100L;
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)1L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test4() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test4");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(0x80000000L);
        String sgName = "root.compactionSchedulerTest-test4";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test5() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test5");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        String sgName = "root.compactionSchedulerTest-test5";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test6() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test6");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        String sgName = "root.compactionSchedulerTest-test6";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test7() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test7");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        String sgName = "root.compactionSchedulerTest-test7";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test8() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test8");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(100);
        String sgName = "root.compactionSchedulerTest-test8";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test9() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test9");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test9";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 25) {
                Thread.sleep(100L);
                CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                if ((totalWaitingTime += 100L) <= 60000L) continue;
                Assert.fail();
            }
            Assert.assertTrue((tsFileManager.getTsFileList(true).size() <= 25 ? 1 : 0) != 0);
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test10() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test10");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        boolean prevEnableCrossCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(false);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test10";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 25) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
            IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(prevEnableCrossCompaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test11() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test11");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test11";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 25) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test12() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test12");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test12";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 96) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test14() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test14");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test13";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 99) {
                try {
                    Thread.sleep(100L);
                    Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test15() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test15");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test14";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 99) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test16() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test16");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread();
        IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(2);
        String sgName = "root.compactionSchedulerTest-test16";
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath(sgName));
        }
        catch (Exception e) {
            logger.error("exception occurs", (Throwable)e);
        }
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
                PartialPath path = new PartialPath(sgName + device);
                IoTDB.metaManager.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 96) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    CompactionTaskManager.getInstance().submitTaskFromTaskQueue();
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentCompactionThread(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(prevMaxCompactionCandidateFileNum);
        }
    }

    public void stopCompactionTaskManager() {
        CompactionTaskManager.getInstance().clearCandidateQueue();
        while (CompactionTaskManager.getInstance().getRunningCompactionTaskList().size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }
}

