/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.junit.Assert;

public class AbstractCompactionTest {
    protected int seqFileNum = 5;
    protected int unseqFileNum = 0;
    protected List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    protected List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private int chunkGroupSize = 0;
    private int pageSize = 0;
    protected String COMPACTION_TEST_SG = "root.testsg";
    private static final long oldTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    private static final int oldChunkGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
    private static final int oldPagePointSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
    private static final int oldMaxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
    protected static File STORAGE_GROUP_DIR = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + "root.compactionTest");
    protected static File SEQ_DIRS = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0");
    protected static File UNSEQ_DIRS = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "unsequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0");
    private int fileVersion = 0;

    public void setUp() throws IOException, WriteProcessException, MetadataException {
        if (!SEQ_DIRS.exists()) {
            Assert.assertTrue((boolean)SEQ_DIRS.mkdirs());
        }
        if (!UNSEQ_DIRS.exists()) {
            Assert.assertTrue((boolean)UNSEQ_DIRS.mkdirs());
        }
        EnvironmentUtils.envSetUp();
        IoTDB.metaManager.init();
    }

    protected void createFiles(int fileNum, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int timeInterval, int valueInterval, boolean isAlign, boolean isSeq) throws IOException, WriteProcessException, MetadataException {
        for (int i = 0; i < fileNum; ++i) {
            String fileName = System.currentTimeMillis() + "-" + this.fileVersion++ + "-0-0.tsfile";
            String filePath = isSeq ? SEQ_DIRS.getPath() + File.separator + fileName : UNSEQ_DIRS.getPath() + File.separator + fileName;
            File file = isAlign ? TsFileGeneratorUtils.generateAlignedTsFile((String)filePath, (int)deviceNum, (int)measurementNum, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (int)(startValue + pointNum * i + valueInterval * i), (int)this.chunkGroupSize, (int)this.pageSize) : TsFileGeneratorUtils.generateNonAlignedTsFile((String)filePath, (int)deviceNum, (int)measurementNum, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (int)(startValue + pointNum * i + valueInterval * i), (int)this.chunkGroupSize, (int)this.pageSize);
            this.addResource(file, deviceNum, startTime + pointNum * i + timeInterval * i, startTime + pointNum * i + timeInterval * i + pointNum - 1, isAlign, isSeq);
        }
    }

    private void addResource(File file, int deviceNum, long startTime, long endTime, boolean isAlign, boolean isSeq) throws IOException {
        TsFileResource resource = new TsFileResource(file);
        int deviceStartindex = 0;
        if (isAlign) {
            for (int i = deviceStartindex = TsFileGeneratorUtils.getAlignDeviceOffset(); i < deviceStartindex + deviceNum; ++i) {
                resource.updateStartTime(this.COMPACTION_TEST_SG + "." + "d" + i, startTime);
                resource.updateEndTime(this.COMPACTION_TEST_SG + "." + "d" + i, endTime);
            }
        } else {
            for (int i = deviceStartindex; i < deviceStartindex + deviceNum; ++i) {
                resource.updateStartTime(this.COMPACTION_TEST_SG + "." + "d" + i, startTime);
                resource.updateEndTime(this.COMPACTION_TEST_SG + "." + "d" + i, endTime);
            }
        }
        resource.updatePlanIndexes((long)this.fileVersion);
        resource.setStatus(TsFileResourceStatus.CLOSED);
        resource.serialize();
        if (isSeq) {
            this.seqResources.add(resource);
        } else {
            this.unseqResources.add(resource);
        }
    }

    protected void registerTimeseriesInMManger(int deviceNum, int measurementNum, boolean isAligned) throws MetadataException {
        for (int i = 0; i < deviceNum; ++i) {
            if (isAligned) {
                ArrayList<String> measurements = new ArrayList<String>();
                ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
                ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
                for (int j = 0; j < measurementNum; ++j) {
                    measurements.add("s" + j);
                    dataTypes.add(TSDataType.INT64);
                    encodings.add(TSEncoding.PLAIN);
                    compressionTypes.add(CompressionType.UNCOMPRESSED);
                    IoTDB.metaManager.createTimeseries(new PartialPath(this.COMPACTION_TEST_SG + "." + "d" + i, "s" + j), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap());
                }
                IoTDB.metaManager.createAlignedTimeSeries(new PartialPath(this.COMPACTION_TEST_SG + "." + "d" + (i + 10000)), measurements, dataTypes, encodings, compressionTypes);
                continue;
            }
            for (int j = 0; j < measurementNum; ++j) {
                IoTDB.metaManager.createTimeseries(new PartialPath(this.COMPACTION_TEST_SG + "." + "d" + i, "s" + j), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap());
            }
        }
    }

    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        this.removeFiles();
        this.seqResources.clear();
        this.unseqResources.clear();
        IoTDB.metaManager.clear();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(oldTargetChunkSize);
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(oldMaxCrossCompactionFileNum);
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(oldChunkGroupSize);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(oldPagePointSize);
        EnvironmentUtils.cleanEnv();
        if (SEQ_DIRS.exists()) {
            FileUtils.deleteDirectory((File)SEQ_DIRS);
        }
        if (UNSEQ_DIRS.exists()) {
            FileUtils.deleteDirectory((File)UNSEQ_DIRS);
        }
    }

    private void removeFiles() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (TsFileResource tsFileResource : this.seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
    }
}

