/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class OperationSyncManualTestUtils {
    private static final SessionPool sessionPool = new SessionPool("127.0.0.1", 6667, "root", "root", 3);
    private static final String sg = "root.sg";
    private static final int sgCnt = 10;
    private static final String d = ".d";
    private static final int dCnt = 20;
    private static final String s = ".s";
    private static final int sCnt = 100;
    private static final int dataCnt = 1000;

    public void setStorageGroups() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 10; ++i) {
            sessionPool.setStorageGroup(sg + i);
        }
    }

    public void deleteStorageGroups() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 10; ++i) {
            sessionPool.deleteStorageGroups(Collections.singletonList(sg + i));
        }
    }

    public void createTimeSeries() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 10; ++i) {
            String SG = sg + i;
            for (int j = 0; j < 20; ++j) {
                String D = d + j;
                for (int k = 0; k < 100; ++k) {
                    String S = s + k;
                    sessionPool.createTimeseries(SG + D + S, TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
                }
            }
        }
    }

    public void deleteTimeSeries() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 10; ++i) {
            String SG = sg + i;
            for (int j = 0; j < 20; ++j) {
                String D = d + j;
                for (int k = 0; k < 100; ++k) {
                    String S = s + k;
                    sessionPool.deleteTimeseries(SG + D + S);
                }
            }
        }
    }

    public void insertData() throws IoTDBConnectionException, StatementExecutionException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            String SG = sg + i;
            for (int j = 0; j < 20; ++j) {
                String D = d + j;
                String device = SG + D;
                ArrayList<String> measurements = new ArrayList<String>();
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                for (int k = 0; k < 100; ++k) {
                    measurements.add("s" + k);
                    types.add(TSDataType.INT32);
                }
                for (int l = 0; l < 1000; ++l) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int k = 0; k < 100; ++k) {
                        values.add(l);
                    }
                    sessionPool.insertRecord(device, (long)l, measurements, types, values);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Avg time per insert: " + (double)(endTime - startTime) / 1030.0 + "ms");
    }

    public void deleteData() throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 10; ++i) {
            String SG = sg + i;
            for (int j = 0; j < 20; ++j) {
                String D = d + j;
                for (int k = 0; k < 100; ++k) {
                    String S = s + k;
                    sessionPool.deleteData(Collections.singletonList(SG + D + S), 0L, 1000L);
                }
            }
        }
    }
}

