/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy;
import org.apache.iotdb.db.conf.directories.strategy.MinFolderOccupiedSpaceFirstStrategy;
import org.apache.iotdb.db.conf.directories.strategy.RandomOnDiskUsableSpaceStrategy;
import org.apache.iotdb.db.conf.directories.strategy.SequenceStrategy;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"com.sun.org.apache.xerces.*", "javax.xml.*", "org.xml.*", "org.w3c.*"})
@PrepareForTest(value={CommonUtils.class})
public class DirectoryStrategyTest {
    List<String> dataDirList;
    Set<Integer> fullDirIndexSet;

    @Before
    public void setUp() throws IOException {
        int i;
        this.dataDirList = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            this.dataDirList.add(TestConstant.OUTPUT_DATA_DIR + i);
        }
        this.fullDirIndexSet = new HashSet<Integer>();
        this.fullDirIndexSet.add(1);
        this.fullDirIndexSet.add(3);
        PowerMockito.mockStatic(CommonUtils.class, (Class[])new Class[0]);
        for (i = 0; i < this.dataDirList.size(); ++i) {
            boolean res = !this.fullDirIndexSet.contains(i);
            PowerMockito.when((Object)CommonUtils.hasSpace((String)this.dataDirList.get(i))).thenReturn((Object)res);
            PowerMockito.when((Object)CommonUtils.getUsableSpace((String)this.dataDirList.get(i))).thenReturn((Object)(res ? (long)(i + 1) : 0L));
            PowerMockito.when((Object)CommonUtils.getOccupiedSpace((String)this.dataDirList.get(i))).thenReturn((Object)(res ? (long)(i + 1) : Long.MAX_VALUE));
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSequenceStrategy() throws DiskSpaceInsufficientException {
        SequenceStrategy sequenceStrategy = new SequenceStrategy();
        sequenceStrategy.setFolders(this.dataDirList);
        int index = 0;
        int i = 0;
        while (i < this.dataDirList.size() * 2) {
            index %= this.dataDirList.size();
            while (this.fullDirIndexSet.contains(index)) {
                index = (index + 1) % this.dataDirList.size();
            }
            Assert.assertEquals((long)index, (long)sequenceStrategy.nextFolderIndex());
            ++i;
            ++index;
        }
    }

    @Test
    public void testMaxDiskUsableSpaceFirstStrategy() throws DiskSpaceInsufficientException {
        int i;
        MaxDiskUsableSpaceFirstStrategy maxDiskUsableSpaceFirstStrategy = new MaxDiskUsableSpaceFirstStrategy();
        maxDiskUsableSpaceFirstStrategy.setFolders(this.dataDirList);
        int maxIndex = this.getIndexOfMaxSpace();
        for (i = 0; i < this.dataDirList.size(); ++i) {
            Assert.assertEquals((long)maxIndex, (long)maxDiskUsableSpaceFirstStrategy.nextFolderIndex());
        }
        PowerMockito.when((Object)CommonUtils.getUsableSpace((String)this.dataDirList.get(maxIndex))).thenReturn((Object)0L);
        maxIndex = this.getIndexOfMaxSpace();
        for (i = 0; i < this.dataDirList.size(); ++i) {
            Assert.assertEquals((long)maxIndex, (long)maxDiskUsableSpaceFirstStrategy.nextFolderIndex());
        }
    }

    private int getIndexOfMaxSpace() {
        int index = -1;
        long maxSpace = -1L;
        for (int i = 0; i < this.dataDirList.size(); ++i) {
            long space = CommonUtils.getUsableSpace((String)this.dataDirList.get(i));
            if (maxSpace >= space) continue;
            index = i;
            maxSpace = space;
        }
        return index;
    }

    @Test
    public void testMinFolderOccupiedSpaceFirstStrategy() throws DiskSpaceInsufficientException, IOException {
        int i;
        MinFolderOccupiedSpaceFirstStrategy minFolderOccupiedSpaceFirstStrategy = new MinFolderOccupiedSpaceFirstStrategy();
        minFolderOccupiedSpaceFirstStrategy.setFolders(this.dataDirList);
        int minIndex = this.getIndexOfMinOccupiedSpace();
        for (i = 0; i < this.dataDirList.size(); ++i) {
            Assert.assertEquals((long)minIndex, (long)minFolderOccupiedSpaceFirstStrategy.nextFolderIndex());
        }
        PowerMockito.when((Object)CommonUtils.getOccupiedSpace((String)this.dataDirList.get(minIndex))).thenReturn((Object)Long.MAX_VALUE);
        minIndex = this.getIndexOfMinOccupiedSpace();
        for (i = 0; i < this.dataDirList.size(); ++i) {
            Assert.assertEquals((long)minIndex, (long)minFolderOccupiedSpaceFirstStrategy.nextFolderIndex());
        }
    }

    private int getIndexOfMinOccupiedSpace() throws IOException {
        int index = -1;
        long minOccupied = Long.MAX_VALUE;
        for (int i = 0; i < this.dataDirList.size(); ++i) {
            long space = CommonUtils.getOccupiedSpace((String)this.dataDirList.get(i));
            if (minOccupied <= space) continue;
            index = i;
            minOccupied = space;
        }
        return index;
    }

    @Test
    public void testRandomOnDiskUsableSpaceStrategy() throws DiskSpaceInsufficientException {
        RandomOnDiskUsableSpaceStrategy randomOnDiskUsableSpaceStrategy = new RandomOnDiskUsableSpaceStrategy();
        randomOnDiskUsableSpaceStrategy.setFolders(this.dataDirList);
        for (int i = 0; i < this.dataDirList.size(); ++i) {
            Assert.assertFalse((boolean)this.fullDirIndexSet.contains(randomOnDiskUsableSpaceStrategy.nextFolderIndex()));
        }
        int newFullIndex = randomOnDiskUsableSpaceStrategy.nextFolderIndex();
        PowerMockito.when((Object)CommonUtils.getUsableSpace((String)this.dataDirList.get(newFullIndex))).thenReturn((Object)0L);
        for (int i = 0; i < this.dataDirList.size(); ++i) {
            int index = randomOnDiskUsableSpaceStrategy.nextFolderIndex();
            Assert.assertFalse((boolean)this.fullDirIndexSet.contains(index));
            Assert.assertTrue((newFullIndex != index ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAllDiskFull() {
        for (int i = 0; i < this.dataDirList.size(); ++i) {
            PowerMockito.when((Object)CommonUtils.hasSpace((String)this.dataDirList.get(i))).thenReturn((Object)false);
        }
        SequenceStrategy sequenceStrategy = new SequenceStrategy();
        try {
            sequenceStrategy.setFolders(this.dataDirList);
            Assert.fail();
        }
        catch (DiskSpaceInsufficientException diskSpaceInsufficientException) {
            // empty catch block
        }
        MaxDiskUsableSpaceFirstStrategy maxDiskUsableSpaceFirstStrategy = new MaxDiskUsableSpaceFirstStrategy();
        try {
            maxDiskUsableSpaceFirstStrategy.setFolders(this.dataDirList);
            Assert.fail();
        }
        catch (DiskSpaceInsufficientException diskSpaceInsufficientException) {
            // empty catch block
        }
        MinFolderOccupiedSpaceFirstStrategy minFolderOccupiedSpaceFirstStrategy = new MinFolderOccupiedSpaceFirstStrategy();
        try {
            minFolderOccupiedSpaceFirstStrategy.setFolders(this.dataDirList);
            Assert.fail();
        }
        catch (DiskSpaceInsufficientException diskSpaceInsufficientException) {
            // empty catch block
        }
    }
}

