/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.thrift.server.TThreadPoolServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBThreadPoolFactoryTest {
    private final String POOL_NAME = "test";
    private AtomicInteger count;
    private CountDownLatch latch;

    @Before
    public void setUp() throws Exception {
        this.count = new AtomicInteger(0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testNewFixedThreadPool() {
        String reason = "(can be ignored in Tests) NewFixedThreadPool";
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 4;
        this.latch = new CountDownLatch(threadCount);
        ExecutorService exec = IoTDBThreadPoolFactory.newFixedThreadPool((int)(threadCount / 2), (String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            exec.execute((Runnable)((Object)task));
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    @Test
    public void testNewSingleThreadExecutor() {
        String reason = "(can be ignored in Tests)NewSingleThreadExecutor";
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 2;
        this.latch = new CountDownLatch(threadCount);
        ExecutorService exec = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            exec.execute((Runnable)((Object)task));
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    @Test
    public void testNewCachedThreadPool() {
        String reason = "(can be ignored in Tests) NewCachedThreadPool";
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 4;
        this.latch = new CountDownLatch(threadCount);
        ExecutorService exec = IoTDBThreadPoolFactory.newCachedThreadPool((String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            exec.execute((Runnable)((Object)task));
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    @Test
    public void testNewSingleThreadScheduledExecutor() throws InterruptedException {
        String reason = "(can be ignored in Tests) NewSingleThreadScheduledExecutor";
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 2;
        this.latch = new CountDownLatch(threadCount);
        ScheduledExecutorService exec = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            ScheduledFuture<?> future = exec.scheduleAtFixedRate((Runnable)((Object)task), 0L, 1L, TimeUnit.SECONDS);
            try {
                future.get();
                continue;
            }
            catch (ExecutionException e) {
                Assert.assertEquals((Object)reason, (Object)e.getCause().getMessage());
                this.count.addAndGet(1);
                this.latch.countDown();
            }
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    @Test
    public void testNewScheduledThreadPool() throws InterruptedException {
        String reason = "(can be ignored in Tests) NewScheduledThreadPool";
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 4;
        this.latch = new CountDownLatch(threadCount);
        ScheduledExecutorService exec = IoTDBThreadPoolFactory.newScheduledThreadPool((int)(threadCount / 2), (String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            ScheduledFuture<?> future = exec.scheduleAtFixedRate((Runnable)((Object)task), 0L, 1L, TimeUnit.SECONDS);
            try {
                future.get();
                continue;
            }
            catch (ExecutionException e) {
                Assert.assertEquals((Object)reason, (Object)e.getCause().getMessage());
                this.count.addAndGet(1);
                this.latch.countDown();
            }
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    @Test
    public void testCreateJDBCClientThreadPool() {
        String reason = "(can be ignored in Tests) CreateJDBCClientThreadPool";
        TThreadPoolServer.Args args = new TThreadPoolServer.Args(null);
        args.maxWorkerThreads = 4;
        args.minWorkerThreads = 2;
        args.stopTimeoutVal = 10;
        args.stopTimeoutUnit = TimeUnit.SECONDS;
        TestExceptionHandler handler = new TestExceptionHandler(reason);
        int threadCount = 4;
        this.latch = new CountDownLatch(threadCount);
        ExecutorService exec = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool((TThreadPoolServer.Args)args, (String)"test", (Thread.UncaughtExceptionHandler)handler);
        for (int i = 0; i < threadCount; ++i) {
            TestThread task = new TestThread(reason);
            exec.execute((Runnable)((Object)task));
        }
        try {
            this.latch.await();
            Assert.assertEquals((long)this.count.get(), (long)threadCount);
        }
        catch (InterruptedException E) {
            Assert.fail();
        }
    }

    class TestThread
    extends WrappedRunnable {
        private String name;

        public TestThread(String name) {
            this.name = name;
        }

        public void runMayThrow() {
            throw new RuntimeException(this.name);
        }
    }

    class TestExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private String name;

        public TestExceptionHandler(String name) {
            this.name = name;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Assert.assertEquals((Object)this.name, (Object)e.getMessage());
            IoTDBThreadPoolFactoryTest.this.count.addAndGet(1);
            IoTDBThreadPoolFactoryTest.this.latch.countDown();
        }
    }
}

