/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBDefaultThreadExceptionHandlerTest {
    private final String message = "Expected!";
    private Thread.UncaughtExceptionHandler handler;
    private AtomicInteger count;

    @Before
    public void setUp() {
        this.handler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new TestExceptionHandler("Expected!"));
        this.count = new AtomicInteger(0);
    }

    @After
    public void tearDown() {
        Thread.setDefaultUncaughtExceptionHandler(this.handler);
    }

    @Test
    public void test() throws InterruptedException {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            TestThread thread = new TestThread();
            thread.start();
        }
        Thread.sleep(500L);
        Assert.assertEquals((long)num, (long)this.count.get());
    }

    class TestExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private String name;

        public TestExceptionHandler(String name) {
            this.name = name;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Assert.assertEquals((Object)this.name, (Object)e.getMessage());
            IoTDBDefaultThreadExceptionHandlerTest.this.count.addAndGet(1);
        }
    }

    class TestThread
    extends Thread {
        TestThread() {
        }

        @Override
        public void run() {
            throw new RuntimeException("Expected!");
        }
    }
}

