/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.role.LocalFileRoleManager;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileRoleManagerTest {
    private File testFolder;
    private LocalFileRoleManager manager;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.manager = new LocalFileRoleManager(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws AuthException {
        Role[] roles = new Role[5];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new Role("role" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege("root.a.b.c" + j);
                pathPrivilege.getPrivileges().add(j);
                roles[i].getPrivilegeList().add(pathPrivilege);
            }
        }
        Role role = this.manager.getRole(roles[0].getName());
        Assert.assertNull((Object)role);
        for (Role role1 : roles) {
            Assert.assertTrue((boolean)this.manager.createRole(role1.getName()));
        }
        for (Role role1 : roles) {
            role = this.manager.getRole(role1.getName());
            Assert.assertEquals((Object)role1.getName(), (Object)role.getName());
        }
        Assert.assertFalse((boolean)this.manager.createRole(roles[0].getName()));
        boolean caught = false;
        try {
            this.manager.createRole("too");
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        try {
            this.manager.createRole("rolename ");
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertFalse((boolean)this.manager.deleteRole("not a role"));
        Assert.assertTrue((boolean)this.manager.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertNull((Object)this.manager.getRole(roles[roles.length - 1].getName()));
        Assert.assertFalse((boolean)this.manager.deleteRole(roles[roles.length - 1].getName()));
        role = this.manager.getRole(roles[0].getName());
        String path = "root.a.b.c";
        int privilegeId = 0;
        Assert.assertFalse((boolean)role.hasPrivilege(path, privilegeId));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId + 1));
        Assert.assertFalse((boolean)this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId));
        role = this.manager.getRole(roles[0].getName());
        Assert.assertTrue((boolean)role.hasPrivilege(path, privilegeId));
        caught = false;
        try {
            this.manager.grantPrivilegeToRole("not a role", path, privilegeId);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            this.manager.grantPrivilegeToRole(role.getName(), path, -1);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        role = this.manager.getRole(roles[0].getName());
        Assert.assertTrue((boolean)this.manager.revokePrivilegeFromRole(role.getName(), path, privilegeId));
        Assert.assertFalse((boolean)this.manager.revokePrivilegeFromRole(role.getName(), path, privilegeId));
        caught = false;
        try {
            this.manager.revokePrivilegeFromRole("not a role", path, privilegeId);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            this.manager.revokePrivilegeFromRole(role.getName(), path, -1);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        List rolenames = this.manager.listAllRoles();
        rolenames.sort(null);
        for (int i = 0; i < roles.length - 1; ++i) {
            Assert.assertEquals((Object)roles[i].getName(), rolenames.get(i));
        }
    }
}

