/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileRoleAccessorTest {
    private File testFolder;
    private LocalFileRoleAccessor accessor;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.accessor = new LocalFileRoleAccessor(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws IOException {
        Role[] roles = new Role[5];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new Role("role" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege("root.a.b.c" + j);
                pathPrivilege.getPrivileges().add(j);
                roles[i].getPrivilegeList().add(pathPrivilege);
            }
        }
        for (Role role : roles) {
            this.accessor.saveRole(role);
        }
        for (Role role : roles) {
            Role loadedRole = this.accessor.loadRole(role.getName());
            Assert.assertEquals((Object)role, (Object)loadedRole);
        }
        Assert.assertNull((Object)this.accessor.loadRole("not a role"));
        Assert.assertTrue((boolean)this.accessor.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertFalse((boolean)this.accessor.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertNull((Object)this.accessor.loadRole(roles[roles.length - 1].getName()));
        List roleNames = this.accessor.listAllRoles();
        roleNames.sort(null);
        for (int i = 0; i < roleNames.size(); ++i) {
            Assert.assertEquals((Object)roles[i].getName(), roleNames.get(i));
        }
    }
}

