/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.authorizer;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileAuthorizerTest {
    IAuthorizer authorizer;
    User user;
    String nodeName = "root.laptop.d1";
    String roleName = "role";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.authorizer = BasicAuthorizer.getInstance();
        this.user = new User("user", "password");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testLogin() throws AuthException {
        Assert.assertTrue((boolean)this.authorizer.login("root", "root"));
        Assert.assertFalse((boolean)this.authorizer.login("root", "error"));
    }

    @Test
    public void createAndDeleteUser() throws AuthException {
        this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        try {
            this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"User user already exists", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)this.authorizer.login(this.user.getName(), this.user.getPassword()));
        this.authorizer.deleteUser(this.user.getName());
        try {
            this.authorizer.deleteUser(this.user.getName());
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"User user does not exist", (Object)e.getMessage());
        }
        try {
            this.authorizer.deleteUser("root");
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Default administrator cannot be deleted", (Object)e.getMessage());
        }
    }

    @Test
    public void testUserPermission() throws AuthException {
        this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, 1);
        try {
            this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"User user already has INSERT_TIMESERIES on root.laptop.d1", (Object)e.getMessage());
        }
        try {
            this.authorizer.grantPrivilegeToUser("error", this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"No such user error", (Object)e.getMessage());
        }
        try {
            this.authorizer.grantPrivilegeToUser("root", this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Invalid operation, administrator already has all privileges", (Object)e.getMessage());
        }
        try {
            this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, 100);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Invalid privilegeId 100", (Object)e.getMessage());
        }
        this.authorizer.revokePrivilegeFromUser(this.user.getName(), this.nodeName, 1);
        try {
            this.authorizer.revokePrivilegeFromUser(this.user.getName(), this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"User user does not have INSERT_TIMESERIES on root.laptop.d1", (Object)e.getMessage());
        }
        try {
            this.authorizer.revokePrivilegeFromUser(this.user.getName(), this.nodeName, 100);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Invalid privilegeId 100", (Object)e.getMessage());
        }
        try {
            this.authorizer.deleteUser(this.user.getName());
            this.authorizer.revokePrivilegeFromUser(this.user.getName(), this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"No such user user", (Object)e.getMessage());
        }
        try {
            this.authorizer.revokePrivilegeFromUser("root", "root", 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Invalid operation, administrator must have all privileges", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateAndDeleteRole() throws AuthException {
        this.authorizer.createRole(this.roleName);
        try {
            this.authorizer.createRole(this.roleName);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Role role already exists", (Object)e.getMessage());
        }
        this.authorizer.deleteRole(this.roleName);
        try {
            this.authorizer.deleteRole(this.roleName);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Role role does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void testRolePermission() throws AuthException {
        this.authorizer.createRole(this.roleName);
        this.authorizer.grantPrivilegeToRole(this.roleName, this.nodeName, 1);
        try {
            this.authorizer.grantPrivilegeToRole(this.roleName, this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Role role already has INSERT_TIMESERIES on root.laptop.d1", (Object)e.getMessage());
        }
        this.authorizer.revokePrivilegeFromRole(this.roleName, this.nodeName, 1);
        try {
            this.authorizer.revokePrivilegeFromRole(this.roleName, this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"Role role does not have INSERT_TIMESERIES on root.laptop.d1", (Object)e.getMessage());
        }
        this.authorizer.deleteRole(this.roleName);
        try {
            this.authorizer.revokePrivilegeFromRole(this.roleName, this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"No such role role", (Object)e.getMessage());
        }
        try {
            this.authorizer.grantPrivilegeToRole(this.roleName, this.nodeName, 1);
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"No such role role", (Object)e.getMessage());
        }
    }

    @Test
    public void testUserRole() throws AuthException {
        this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        this.authorizer.createRole(this.roleName);
        this.authorizer.grantRoleToUser(this.roleName, this.user.getName());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, 1);
        this.authorizer.grantPrivilegeToRole(this.roleName, this.nodeName, 3);
        Set permissions = this.authorizer.getPrivileges(this.user.getName(), this.nodeName);
        Assert.assertEquals((long)2L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains(1));
        Assert.assertTrue((boolean)permissions.contains(3));
        Assert.assertFalse((boolean)permissions.contains(2));
        try {
            this.authorizer.grantRoleToUser(this.roleName, this.user.getName());
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"User user already has role role", (Object)e.getMessage());
        }
        this.authorizer.revokeRoleFromUser(this.roleName, this.user.getName());
        Set revokeRolePermissions = this.authorizer.getPrivileges(this.user.getName(), this.nodeName);
        Assert.assertEquals((long)1L, (long)revokeRolePermissions.size());
        Assert.assertTrue((boolean)revokeRolePermissions.contains(1));
        Assert.assertFalse((boolean)revokeRolePermissions.contains(2));
        Assert.assertTrue((boolean)this.authorizer.checkUserPrivileges(this.user.getName(), this.nodeName, 1));
        Assert.assertFalse((boolean)this.authorizer.checkUserPrivileges(this.user.getName(), this.nodeName, 2));
        try {
            this.authorizer.grantRoleToUser("role1", this.user.getName());
        }
        catch (AuthException e) {
            Assert.assertEquals((Object)"No such role : role1", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdatePassword() throws AuthException {
        this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        this.authorizer.updateUserPassword(this.user.getName(), "newPassword");
        Assert.assertTrue((boolean)this.authorizer.login(this.user.getName(), "newPassword"));
    }

    @Test
    public void testUserWaterMark() throws AuthException {
        this.authorizer.setUserUseWaterMark("root", true);
        Assert.assertTrue((boolean)((Boolean)this.authorizer.getAllUserWaterMarkStatus().get("root")));
        Assert.assertTrue((boolean)this.authorizer.isUserUseWaterMark("root"));
    }

    @Test
    public void testGetAllUsersAndRoles() throws AuthException {
        this.authorizer.createUser("user0", "user");
        this.authorizer.createUser("user1", "user1");
        this.authorizer.createUser("user2", "user2");
        this.authorizer.createRole("role0");
        this.authorizer.createRole("role1");
        this.authorizer.createRole("role2");
        Assert.assertEquals((long)4L, (long)this.authorizer.getAllUsers().size());
        Assert.assertEquals((long)3L, (long)this.authorizer.getAllRoles().size());
    }

    @Test
    public void testListUser() throws AuthException {
        int i;
        IAuthorizer authorizer = BasicAuthorizer.getInstance();
        List userList = authorizer.listAllUsers();
        Assert.assertEquals((long)1L, (long)userList.size());
        Assert.assertEquals((Object)IoTDBDescriptor.getInstance().getConfig().getAdminName(), userList.get(0));
        int userCnt = 10;
        for (i = 0; i < userCnt; ++i) {
            authorizer.createUser("newUser" + i, "password" + i);
        }
        userList = authorizer.listAllUsers();
        Assert.assertEquals((long)11L, (long)userList.size());
        for (i = 0; i < userCnt; ++i) {
            Assert.assertEquals((Object)("newUser" + i), userList.get(i));
        }
        for (i = 0; i < userCnt; ++i) {
            if (i % 2 != 0) continue;
            authorizer.deleteUser("newUser" + i);
        }
        userList = authorizer.listAllUsers();
        Assert.assertEquals((long)6L, (long)userList.size());
        for (i = 0; i < userCnt; ++i) {
            if (i % 2 != 1) continue;
            Assert.assertEquals((Object)("newUser" + i), userList.get(i / 2));
        }
    }

    @Test
    public void testListRole() throws AuthException {
        int i;
        IAuthorizer authorizer = BasicAuthorizer.getInstance();
        List roleList = authorizer.listAllRoles();
        Assert.assertEquals((long)0L, (long)roleList.size());
        int roleCnt = 10;
        for (i = 0; i < roleCnt; ++i) {
            authorizer.createRole("newRole" + i);
        }
        roleList = authorizer.listAllRoles();
        Assert.assertEquals((long)10L, (long)roleList.size());
        for (i = 0; i < roleCnt; ++i) {
            Assert.assertEquals((Object)("newRole" + i), roleList.get(i));
        }
        for (i = 0; i < roleCnt; ++i) {
            if (i % 2 != 0) continue;
            authorizer.deleteRole("newRole" + i);
        }
        roleList = authorizer.listAllRoles();
        Assert.assertEquals((long)5L, (long)roleList.size());
        for (i = 0; i < roleCnt; ++i) {
            if (i % 2 != 1) continue;
            Assert.assertEquals((Object)("newRole" + i), roleList.get(i / 2));
        }
    }

    @Test
    public void testReplaceAllUsers() throws AuthException {
        IAuthorizer authorizer = BasicAuthorizer.getInstance();
        Assert.assertEquals((Object)"root", authorizer.listAllUsers().get(0));
        User user = new User("user", "user");
        HashMap<String, User> users = new HashMap<String, User>();
        users.put("user", user);
        authorizer.replaceAllUsers(users);
        Assert.assertEquals((Object)"user", authorizer.listAllUsers().get(1));
    }

    @Test
    public void testReplaceAllRole() throws AuthException {
        IAuthorizer authorizer = BasicAuthorizer.getInstance();
        Role role = new Role("role");
        HashMap<String, Role> roles = new HashMap<String, Role>();
        roles.put("role", role);
        authorizer.replaceAllRoles(roles);
        Assert.assertEquals((Object)"role", authorizer.listAllRoles().get(0));
    }
}

