/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.dataset.IUDFInputDataSet;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableRowRecordListBackedMultiColumnRow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableRowRecordListBackedMultiColumnWindow;
import org.apache.iotdb.db.query.udf.core.layer.InputRowUtils;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerCacheUtils;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowWindowReader;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class MultiInputColumnIntermediateLayer
extends IntermediateLayer
implements IUDFInputDataSet {
    private final LayerPointReader[] layerPointReaders;
    private final TSDataType[] dataTypes;
    private final TimeSelector timeHeap;

    public MultiInputColumnIntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB, List<LayerPointReader> parentLayerPointReaders) throws QueryProcessException, IOException {
        super(expression, queryId, memoryBudgetInMB);
        this.layerPointReaders = parentLayerPointReaders.toArray(new LayerPointReader[0]);
        this.dataTypes = new TSDataType[this.layerPointReaders.length];
        for (int i = 0; i < this.layerPointReaders.length; ++i) {
            this.dataTypes[i] = this.layerPointReaders[i].getDataType();
        }
        this.timeHeap = new TimeSelector(this.layerPointReaders.length << 1, true);
        for (LayerPointReader reader : this.layerPointReaders) {
            if (reader.isConstantPointReader() || !reader.next()) continue;
            this.timeHeap.add(reader.currentTime());
        }
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return Arrays.asList(this.dataTypes);
    }

    @Override
    public boolean hasNextRowInObjects() {
        return !this.timeHeap.isEmpty();
    }

    @Override
    public Object[] nextRowInObjects() throws IOException {
        long minTime = this.timeHeap.pollFirst();
        int rowLength = this.layerPointReaders.length;
        Object[] row = new Object[rowLength + 1];
        row[rowLength] = minTime;
        try {
            for (int i = 0; i < rowLength; ++i) {
                LayerPointReader reader = this.layerPointReaders[i];
                if (!reader.next() || !reader.isConstantPointReader() && reader.currentTime() != minTime) continue;
                if (!reader.isCurrentNull()) {
                    switch (reader.getDataType()) {
                        case INT32: {
                            row[i] = reader.currentInt();
                            break;
                        }
                        case INT64: {
                            row[i] = reader.currentLong();
                            break;
                        }
                        case FLOAT: {
                            row[i] = Float.valueOf(reader.currentFloat());
                            break;
                        }
                        case DOUBLE: {
                            row[i] = reader.currentDouble();
                            break;
                        }
                        case BOOLEAN: {
                            row[i] = reader.currentBoolean();
                            break;
                        }
                        case TEXT: {
                            row[i] = reader.currentBinary();
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException("Unsupported data type.");
                        }
                    }
                }
                reader.readyForNext();
                if (reader.isConstantPointReader() || !reader.next()) continue;
                this.timeHeap.add(reader.currentTime());
            }
        }
        catch (QueryProcessException e) {
            throw new IOException(e.getMessage());
        }
        return row;
    }

    @Override
    public LayerPointReader constructPointReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final ElasticSerializableRowRecordListBackedMultiColumnRow row;
            private boolean hasCached;
            private boolean currentNull;
            {
                this.row = new ElasticSerializableRowRecordListBackedMultiColumnRow(MultiInputColumnIntermediateLayer.this.dataTypes);
                this.hasCached = false;
                this.currentNull = false;
            }

            @Override
            public boolean next() throws IOException {
                if (this.hasCached) {
                    return true;
                }
                if (!MultiInputColumnIntermediateLayer.this.hasNextRowInObjects()) {
                    return false;
                }
                Object[] rowRecords = MultiInputColumnIntermediateLayer.this.nextRowInObjects();
                this.currentNull = InputRowUtils.isAllNull(rowRecords);
                this.row.setRowRecord(rowRecords);
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.currentNull = false;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public long currentTime() {
                return this.row.getTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() {
                return this.currentNull;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) throws QueryProcessException {
        final MultiInputColumnIntermediateLayer udfInputDataSet = this;
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableRowRecordList rowRecordList;
            private final ElasticSerializableRowRecordListBackedMultiColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.rowRecordList = new ElasticSerializableRowRecordList(MultiInputColumnIntermediateLayer.this.dataTypes, MultiInputColumnIntermediateLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(this.rowRecordList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                int rowsToBeCollected = endIndex - this.rowRecordList.size();
                if (0 < rowsToBeCollected) {
                    LayerCacheUtils.cacheRows(udfInputDataSet, this.rowRecordList, rowsToBeCollected);
                    if (this.rowRecordList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, this.rowRecordList.size(), this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(this.rowRecordList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.rowRecordList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException, IOException {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final MultiInputColumnIntermediateLayer udfInputDataSet = this;
        final ElasticSerializableRowRecordList rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableRowRecordListBackedMultiColumnWindow window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(rowRecordList);
        long nextWindowTimeBeginGivenByStrategy = strategy.getDisplayWindowBegin();
        if (rowRecordList.size() == 0 && LayerCacheUtils.cacheRow(udfInputDataSet, rowRecordList) && nextWindowTimeBeginGivenByStrategy == Long.MIN_VALUE) {
            nextWindowTimeBeginGivenByStrategy = rowRecordList.getTime(0);
        }
        final long finalNextWindowTimeBeginGivenByStrategy = nextWindowTimeBeginGivenByStrategy;
        final boolean hasAtLeastOneRow = rowRecordList.size() != 0;
        return new LayerRowWindowReader(){
            private boolean hasCached = false;
            private long nextWindowTimeBegin = finalNextWindowTimeBeginGivenByStrategy;
            private int nextIndexBegin = 0;

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                if (!hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (rowRecordList.getTime(rowRecordList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cacheRow(udfInputDataSet, rowRecordList)) {
                }
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= rowRecordList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != rowRecordList.size() - 1) continue;
                    this.nextIndexBegin = rowRecordList.size();
                }
                int nextIndexEnd = rowRecordList.size();
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (nextWindowTimeEnd > rowRecordList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd;
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                rowRecordList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

