/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class AggregateResult {
    public static final int TIME_LENGTH_FOR_FIRST_VALUE = 100;
    private final AggregationType aggregationType;
    protected TSDataType resultDataType;
    private boolean booleanValue;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private Binary binaryValue;
    protected boolean hasCandidateResult;

    public AggregateResult(TSDataType resultDataType, AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        this.resultDataType = resultDataType;
        this.hasCandidateResult = false;
    }

    public abstract Object getResult();

    public abstract void updateResultFromStatistics(Statistics var1) throws QueryProcessException;

    public abstract void updateResultFromPageData(IBatchDataIterator var1) throws IOException, QueryProcessException;

    public abstract void updateResultFromPageData(IBatchDataIterator var1, long var2, long var4) throws IOException;

    public abstract void updateResultUsingTimestamps(long[] var1, int var2, IReaderByTimestamp var3) throws IOException;

    public abstract void updateResultUsingValues(long[] var1, int var2, ValueIterator var3);

    public abstract boolean hasFinalResult();

    public abstract void merge(AggregateResult var1);

    public static AggregateResult deserializeFrom(ByteBuffer buffer) {
        AggregationType aggregationType = AggregationType.deserialize(buffer);
        TSDataType dataType = TSDataType.deserialize((byte)buffer.get());
        boolean ascending = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByType(aggregationType, dataType, ascending);
        boolean hasResult = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (hasResult) {
            switch (dataType) {
                case BOOLEAN: {
                    aggregateResult.setBooleanValue(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
                    break;
                }
                case INT32: {
                    aggregateResult.setIntValue(buffer.getInt());
                    break;
                }
                case INT64: {
                    aggregateResult.setLongValue(buffer.getLong());
                    break;
                }
                case FLOAT: {
                    aggregateResult.setFloatValue(buffer.getFloat());
                    break;
                }
                case DOUBLE: {
                    aggregateResult.setDoubleValue(buffer.getDouble());
                    break;
                }
                case TEXT: {
                    aggregateResult.setBinaryValue(ReadWriteIOUtils.readBinary((ByteBuffer)buffer));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Aggregation Type: " + dataType.name());
                }
            }
            aggregateResult.deserializeSpecificFields(buffer);
        }
        return aggregateResult;
    }

    protected abstract void deserializeSpecificFields(ByteBuffer var1);

    public void serializeTo(OutputStream outputStream) throws IOException {
        this.aggregationType.serializeTo(outputStream);
        ReadWriteIOUtils.write((TSDataType)this.resultDataType, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isAscending(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.hasCandidateResult(), (OutputStream)outputStream);
        if (this.hasCandidateResult()) {
            switch (this.resultDataType) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)this.booleanValue, (OutputStream)outputStream);
                    break;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)this.intValue, (OutputStream)outputStream);
                    break;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)this.longValue, (OutputStream)outputStream);
                    break;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)this.floatValue, (OutputStream)outputStream);
                    break;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)this.doubleValue, (OutputStream)outputStream);
                    break;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)this.binaryValue, (OutputStream)outputStream);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Aggregation Type: " + this.resultDataType.name());
                }
            }
            this.serializeSpecificFields(outputStream);
        }
    }

    protected abstract void serializeSpecificFields(OutputStream var1) throws IOException;

    public void reset() {
        this.hasCandidateResult = false;
        this.booleanValue = false;
        this.doubleValue = 0.0;
        this.floatValue = 0.0f;
        this.intValue = 0;
        this.longValue = 0L;
        this.binaryValue = null;
    }

    protected Object getValue() {
        switch (this.resultDataType) {
            case BOOLEAN: {
                return this.booleanValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case TEXT: {
                return this.binaryValue;
            }
            case FLOAT: {
                return Float.valueOf(this.floatValue);
            }
            case INT32: {
                return this.intValue;
            }
            case INT64: {
                return this.longValue;
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(this.resultDataType));
    }

    protected void setValue(Object v) {
        this.hasCandidateResult = true;
        switch (this.resultDataType) {
            case BOOLEAN: {
                this.booleanValue = (Boolean)v;
                break;
            }
            case DOUBLE: {
                this.doubleValue = (Double)v;
                break;
            }
            case TEXT: {
                this.binaryValue = (Binary)v;
                break;
            }
            case FLOAT: {
                this.floatValue = ((Float)v).floatValue();
                break;
            }
            case INT32: {
                this.intValue = (Integer)v;
                break;
            }
            case INT64: {
                this.longValue = (Long)v;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.resultDataType));
            }
        }
    }

    public TSDataType getResultDataType() {
        return this.resultDataType;
    }

    protected boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.hasCandidateResult = true;
        this.booleanValue = booleanValue;
    }

    protected int getIntValue() {
        return this.intValue;
    }

    public void setIntValue(int intValue) {
        this.hasCandidateResult = true;
        this.intValue = intValue;
    }

    protected long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.hasCandidateResult = true;
        this.longValue = longValue;
    }

    protected float getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(float floatValue) {
        this.hasCandidateResult = true;
        this.floatValue = floatValue;
    }

    protected double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.hasCandidateResult = true;
        this.doubleValue = doubleValue;
    }

    protected Binary getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(Binary binaryValue) {
        this.hasCandidateResult = true;
        this.binaryValue = binaryValue;
    }

    protected boolean hasCandidateResult() {
        return this.hasCandidateResult;
    }

    public String toString() {
        return String.valueOf(this.getResult());
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public boolean isAscending() {
        return true;
    }
}

