/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.handler;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.protocol.rest.model.InsertTabletRequest;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class PhysicalPlanConstructionHandler {
    private PhysicalPlanConstructionHandler() {
    }

    public static InsertTabletPlan constructInsertTabletPlan(InsertTabletRequest insertTabletRequest) throws IllegalPathException, WriteProcessRejectException {
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(insertTabletRequest.getDeviceId()), insertTabletRequest.getMeasurements());
        List rawData = insertTabletRequest.getValues();
        List rawDataType = insertTabletRequest.getDataTypes();
        int rowSize = insertTabletRequest.getTimestamps().size();
        int columnSize = rawDataType.size();
        Object[] columns = new Object[columnSize];
        BitMap[] bitMaps = new BitMap[columnSize];
        TSDataType[] dataTypes = new TSDataType[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            dataTypes[i] = TSDataType.valueOf((String)((String)rawDataType.get(i)));
        }
        block9: for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            bitMaps[columnIndex] = new BitMap(rowSize);
            switch (dataTypes[columnIndex]) {
                case BOOLEAN: {
                    boolean[] booleanValues = new boolean[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        booleanValues[rowIndex] = (Boolean)((List)rawData.get(columnIndex)).get(rowIndex);
                    }
                    columns[columnIndex] = booleanValues;
                    continue block9;
                }
                case INT32: {
                    int[] intValues = new int[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            intValues[rowIndex] = (Integer)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = intValues;
                    continue block9;
                }
                case INT64: {
                    long[] longValues = new long[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            longValues[rowIndex] = ((Integer)object).intValue();
                            continue;
                        }
                        if (object instanceof Long) {
                            longValues[rowIndex] = (Long)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        floatValues[rowIndex] = ((Double)((List)rawData.get(columnIndex)).get(rowIndex)).floatValue();
                    }
                    columns[columnIndex] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        doubleValues[rowIndex] = (Double)((List)rawData.get(columnIndex)).get(rowIndex);
                    }
                    columns[columnIndex] = doubleValues;
                    continue block9;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            binaryValues[rowIndex] = new Binary("".getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        binaryValues[rowIndex] = new Binary(((List)rawData.get(columnIndex)).get(rowIndex).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    columns[columnIndex] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Invalid input: " + (String)rawDataType.get(columnIndex));
                }
            }
        }
        insertTabletPlan.setTimes(insertTabletRequest.getTimestamps().stream().mapToLong(Long::longValue).toArray());
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setBitMaps(bitMaps);
        insertTabletPlan.setRowCount(insertTabletRequest.getTimestamps().size());
        insertTabletPlan.setDataTypes(dataTypes);
        insertTabletPlan.setAligned(insertTabletRequest.getIsAligned());
        return insertTabletPlan;
    }
}

