/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.micrometer.registry;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metrics.metricsUtils;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMeterRegistry
extends StepMeterRegistry {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBMeterRegistry.class);
    private final ServiceProvider serviceProvider;
    private final int rpcPort;
    private final String address;

    public IoTDBMeterRegistry(StepRegistryConfig config, Clock clock) {
        super(config, clock);
        IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
        this.rpcPort = ioTDBConfig.getRpcPort();
        this.address = ioTDBConfig.getRpcAddress();
        this.serviceProvider = IoTDB.serviceProvider;
    }

    protected void publish() {
        this.getMeters().forEach(meter -> {
            Meter.Id id = meter.getId();
            String name = id.getName();
            List tags = id.getTags();
            Map<String, String> labels = this.tagsConvertToMap(tags);
            meter.use(gauge -> this.updateValue(name, labels, gauge.value()), counter -> this.updateValue(name, labels, counter.count()), timer -> this.writeSnapshotAndCount(name, labels, timer.takeSnapshot()), summary -> this.writeSnapshotAndCount(name, labels, summary.takeSnapshot()), longTaskTimer -> this.updateValue(name, labels, Double.valueOf(longTaskTimer.activeTasks())), timeGauge -> this.updateValue(name, labels, timeGauge.value(this.getBaseTimeUnit())), functionCounter -> this.updateValue(name, labels, functionCounter.count()), functionTimer -> this.updateValue(name, labels, functionTimer.count()), m -> logger.debug("unknown meter:" + meter));
        });
    }

    private void writeSnapshotAndCount(String name, Map<String, String> labels, HistogramSnapshot snapshot) {
        this.updateValue(name + "_max", labels, snapshot.max());
        this.updateValue(name + "_mean", labels, snapshot.mean());
        this.updateValue(name + "_total", labels, snapshot.total());
        this.updateValue(name + "_count", labels, Double.valueOf(snapshot.count()));
    }

    private Map<String, String> tagsConvertToMap(List<Tag> tags) {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Tag tag : tags) {
            labels.put(tag.getKey(), tag.getValue());
        }
        return labels;
    }

    private void updateValue(String name, Map<String, String> labels, Double value) {
        if (value != null) {
            try {
                InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath(metricsUtils.generatePath(this.address, this.rpcPort, name, labels)), System.currentTimeMillis(), new String[]{"value"}, DataTypeUtils.getValueBuffer(new ArrayList<TSDataType>(Arrays.asList(TSDataType.DOUBLE)), new ArrayList<Object>(Arrays.asList(value))), false);
                this.serviceProvider.executeNonQuery(insertRowPlan);
            }
            catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException | QueryProcessException | IoTDBConnectionException e) {
                logger.error("illegal insertRowPlan,reason:" + e.getMessage());
            }
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }
}

