/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.dropwizard.reporter;

import com.codahale.metrics.MetricFilter;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.metrics.dropwizard.reporter.IoTDBReporter;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricManager;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;

public class DropwizardIoTDBReporter
implements Reporter {
    private MetricManager dropwizardMetricManager = null;
    private IoTDBReporter ioTDBReporter;
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();

    public boolean start() {
        if (!metricConfig.getEnableMetric().booleanValue()) {
            return false;
        }
        this.ioTDBReporter = IoTDBReporter.forRegistry(((DropwizardMetricManager)this.dropwizardMetricManager).getMetricRegistry()).prefixedWith("dropwizard:").filter(MetricFilter.ALL).build();
        this.ioTDBReporter.start(metricConfig.getPushPeriodInSecond().intValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean stop() {
        if (this.ioTDBReporter == null) {
            return false;
        }
        this.ioTDBReporter.stop();
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    public void setMetricManager(MetricManager metricManager) {
        this.dropwizardMetricManager = metricManager;
    }
}

