/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.service.metrics.Metric;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class TsFileProcessorInfo {
    private StorageGroupInfo storageGroupInfo;
    private long memCost;

    public TsFileProcessorInfo(StorageGroupInfo storageGroupInfo) {
        this.storageGroupInfo = storageGroupInfo;
        this.memCost = 0L;
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.storageGroupInfo.addStorageGroupMemCost(cost);
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getVirtualStorageGroupProcessor().getLogicalStorageGroupName()}).incr(cost);
        }
    }

    public void releaseTSPMemCost(long cost) {
        this.storageGroupInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getVirtualStorageGroupProcessor().getLogicalStorageGroupName()}).decr(cost);
        }
    }

    public void clear() {
        this.storageGroupInfo.releaseStorageGroupMemCost(this.memCost);
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getVirtualStorageGroupProcessor().getLogicalStorageGroupName()}).decr(this.memCost);
        }
        this.memCost = 0L;
    }
}

