/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.ReadOnlyTsFile;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeqTsFileRecoverTest {
    private File tsF;
    private TsFileWriter writer;
    private WriteLogNode node;
    private String logNodePrefix = TestConstant.BASE_OUTPUT_PATH.concat("testRecover");
    private TsFileResource resource;
    private VersionController versionController = new VersionController(){
        private int i;

        public long nextVersion() {
            return ++this.i;
        }

        public long currVersion() {
            return this.i;
        }
    };

    @Before
    public void setup() throws IOException, WriteProcessException, MetadataException {
        int j;
        int i;
        int i2;
        EnvironmentUtils.envSetUp();
        this.tsF = SystemFileFactory.INSTANCE.getFile(this.logNodePrefix, "1-1-1.tsfile");
        this.tsF.getParentFile().mkdirs();
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
        for (int i3 = 0; i3 < 10; ++i3) {
            for (int j2 = 0; j2 < 10; ++j2) {
                IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device" + i3 + ".sensor" + j2), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
        }
        Schema schema = new Schema();
        HashMap<String, MeasurementSchema> template = new HashMap<String, MeasurementSchema>();
        for (i2 = 0; i2 < 10; ++i2) {
            template.put("sensor" + i2, new MeasurementSchema("sensor" + i2, TSDataType.INT64, TSEncoding.PLAIN));
        }
        schema.registerDeviceTemplate("template1", template);
        for (i2 = 0; i2 < 10; ++i2) {
            schema.registerDevice("root.sg.device" + i2, "template1");
        }
        schema.registerDevice("root.sg.device99", "template1");
        this.writer = new TsFileWriter(this.tsF, schema);
        TSRecord tsRecord = new TSRecord(100L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor4", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        tsRecord = new TSRecord(2L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                tsRecord = new TSRecord((long)i, "root.sg.device" + j);
                for (int k = 0; k < 10; ++k) {
                    tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)("sensor" + k), (String)String.valueOf(k)));
                }
                this.writer.write(tsRecord);
            }
        }
        this.writer.flushAllChunkGroups();
        this.writer.getIOWriter().writePlanIndices();
        this.writer.getIOWriter().close();
        this.node = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + this.tsF.getName(), () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        for (i = 10; i < 20; ++i) {
            for (j = 0; j < 10; ++j) {
                String[] measurements = new String[10];
                TSDataType[] types = new TSDataType[10];
                String[] values = new String[10];
                for (int k = 0; k < 10; ++k) {
                    measurements[k] = "sensor" + k;
                    types[k] = TSDataType.INT64;
                    values[k] = String.valueOf(k);
                }
                InsertRowPlan insertPlan = new InsertRowPlan(new PartialPath("root.sg.device" + j), (long)i, measurements, types, values);
                this.node.write((PhysicalPlan)insertPlan);
            }
            this.node.notifyStartFlush();
        }
        this.resource = new TsFileResource(this.tsF);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        ByteBuffer[] buffers;
        EnvironmentUtils.cleanEnv();
        FileUtils.deleteDirectory((File)this.tsF.getParentFile());
        this.resource.close();
        for (ByteBuffer byteBuffer : buffers = this.node.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    @Test
    public void testNonLastRecovery() throws StorageGroupProcessorException, IOException {
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, false);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        Assert.assertFalse((boolean)writer.canWrite());
        writer.close();
        Assert.assertEquals((long)2L, (long)this.resource.getStartTime("root.sg.device99"));
        Assert.assertEquals((long)100L, (long)this.resource.getEndTime("root.sg.device99"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device" + i));
            Assert.assertEquals((long)19L, (long)this.resource.getEndTime("root.sg.device" + i));
        }
        ReadOnlyTsFile readOnlyTsFile = new ReadOnlyTsFile(new TsFileSequenceReader(this.tsF.getPath()));
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                pathList.add(new Path("root.sg.device" + j, "sensor" + k));
            }
        }
        QueryExpression queryExpression = QueryExpression.create(pathList, null);
        QueryDataSet dataSet = readOnlyTsFile.query(queryExpression);
        for (int i = 0; i < 20; ++i) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)i, (long)record.getTimestamp());
            List fields = record.getFields();
            Assert.assertEquals((long)100L, (long)fields.size());
            for (int j = 0; j < 100; ++j) {
                Assert.assertEquals((long)(j % 10), (long)((Field)fields.get(j)).getLongV());
            }
        }
        pathList = new ArrayList();
        pathList.add(new Path("root.sg.device99", "sensor1"));
        pathList.add(new Path("root.sg.device99", "sensor4"));
        queryExpression = QueryExpression.create(pathList, null);
        dataSet = readOnlyTsFile.query(queryExpression);
        Assert.assertTrue((boolean)dataSet.hasNext());
        RowRecord record = dataSet.next();
        Assert.assertEquals((Object)"2\t0\tnull", (Object)record.toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        record = dataSet.next();
        Assert.assertEquals((Object)"100\tnull\t0", (Object)record.toString());
        readOnlyTsFile.close();
    }

    @Test
    public void testLastRecovery() throws StorageGroupProcessorException, IOException {
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, true);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        writer.makeMetadataVisible();
        Assert.assertEquals((long)11L, (long)writer.getMetadatasForQuery().size());
        Assert.assertEquals((long)2L, (long)this.resource.getStartTime("root.sg.device99"));
        Assert.assertEquals((long)100L, (long)this.resource.getEndTime("root.sg.device99"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device" + i));
            Assert.assertEquals((long)19L, (long)this.resource.getEndTime("root.sg.device" + i));
        }
        ReadOnlyTsFile readOnlyTsFile = new ReadOnlyTsFile(new TsFileSequenceReader(this.tsF.getPath()));
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                pathList.add(new Path("root.sg.device" + j, "sensor" + k));
            }
        }
        QueryExpression queryExpression = QueryExpression.create(pathList, null);
        QueryDataSet dataSet = readOnlyTsFile.query(queryExpression);
        for (int i = 0; i < 20; ++i) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)i, (long)record.getTimestamp());
            List fields = record.getFields();
            Assert.assertEquals((long)100L, (long)fields.size());
            for (int j = 0; j < 100; ++j) {
                Assert.assertEquals((long)(j % 10), (long)((Field)fields.get(j)).getLongV());
            }
        }
        pathList = new ArrayList();
        pathList.add(new Path("root.sg.device99", "sensor1"));
        pathList.add(new Path("root.sg.device99", "sensor4"));
        queryExpression = QueryExpression.create(pathList, null);
        dataSet = readOnlyTsFile.query(queryExpression);
        Assert.assertTrue((boolean)dataSet.hasNext());
        RowRecord record = dataSet.next();
        Assert.assertEquals((Object)"2\t0\tnull", (Object)record.toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        record = dataSet.next();
        Assert.assertEquals((Object)"100\tnull\t0", (Object)record.toString());
        readOnlyTsFile.close();
    }
}

