/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeviceStringTest {
    private File tsF;
    private TsFileWriter writer;
    private String logNodePrefix = TestConstant.OUTPUT_DATA_DIR.concat("testNode/0");
    private Schema schema;
    private TsFileResource resource;
    private MManager mManager = IoTDB.metaManager;

    @Before
    public void setup() throws IOException, WriteProcessException, MetadataException {
        EnvironmentUtils.envSetUp();
        this.tsF = SystemFileFactory.INSTANCE.getFile(this.logNodePrefix, "1-1-1.tsfile");
        this.tsF.getParentFile().mkdirs();
        this.schema = new Schema();
        this.schema.registerTimeseries(new Path("root.sg.device99", "sensor4"), new MeasurementSchema("sensor4", TSDataType.INT64, TSEncoding.PLAIN));
        this.mManager.createTimeseries(new PartialPath("root.sg.device99.sensor4"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.schema.registerTimeseries(new Path("root.sg.device99", "sensor2"), new MeasurementSchema("sensor2", TSDataType.INT64, TSEncoding.PLAIN));
        this.mManager.createTimeseries(new PartialPath("root.sg.device99.sensor2"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.schema.registerTimeseries(new Path("root.sg.device99", "sensor1"), new MeasurementSchema("sensor1", TSDataType.INT64, TSEncoding.PLAIN));
        this.mManager.createTimeseries(new PartialPath("root.sg.device99.sensor1"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.writer = new TsFileWriter(this.tsF, this.schema);
        this.resource = new TsFileResource(this.tsF);
        TSRecord tsRecord = new TSRecord(100L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor4", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        tsRecord = new TSRecord(2L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        this.writer.flushAllChunkGroups();
        this.writer.getIOWriter().close();
        this.resource.updateStartTime(new String("root.sg.device99"), 2L);
        this.resource.updateEndTime(new String("root.sg.device99"), 100L);
        this.resource.close();
        this.resource.serialize();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
        FileUtils.deleteDirectory((File)this.tsF.getParentFile());
        this.resource.close();
    }

    @Test
    public void testDeviceString() throws IOException, IllegalPathException {
        this.resource = new TsFileResource(this.tsF);
        this.resource.deserialize();
        Assert.assertFalse((boolean)this.resource.getDevices().isEmpty());
        for (String device : this.resource.getDevices()) {
            Assert.assertSame((Object)device, (Object)this.mManager.getDeviceId(new PartialPath(device)));
        }
    }
}

