/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.writelog.io.LogWriter;
import org.apache.iotdb.db.writelog.io.MultiFileLogReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiFileLogReaderTest {
    private File[] logFiles;
    private PhysicalPlan[][] fileLogs;
    private int logsPerFile = 5;
    private int fileNum = 3;

    @Before
    public void setup() throws IOException, IllegalPathException {
        this.logFiles = new File[this.fileNum];
        this.fileLogs = new PhysicalPlan[this.fileNum][this.logsPerFile];
        for (int i = 0; i < this.fileNum; ++i) {
            this.logFiles[i] = new File(i + ".log");
            for (int j = 0; j < this.logsPerFile; ++j) {
                this.fileLogs[i][j] = new DeletePlan(Long.MIN_VALUE, (long)(i * this.logsPerFile + j), new PartialPath("path" + j));
            }
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            for (PhysicalPlan plan : this.fileLogs[i]) {
                plan.serialize(buffer);
            }
            LogWriter writer = new LogWriter(this.logFiles[i], IoTDBDescriptor.getInstance().getConfig().getForceWalPeriodInMs() == 0L);
            writer.write(buffer);
            writer.force();
            writer.close();
        }
    }

    @After
    public void teardown() throws IOException {
        for (File logFile : this.logFiles) {
            FileUtils.forceDelete((File)logFile);
        }
    }

    @Test
    public void test() throws IOException {
        MultiFileLogReader reader = new MultiFileLogReader(this.logFiles);
        int i = 0;
        while (reader.hasNext()) {
            PhysicalPlan plan = reader.next();
            Assert.assertEquals((Object)this.fileLogs[i / this.logsPerFile][i % this.logsPerFile], (Object)plan);
            ++i;
        }
        reader.close();
        Assert.assertEquals((long)(this.fileNum * this.logsPerFile), (long)i);
    }
}

