/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.apache.iotdb.db.writelog.node.ExclusiveWriteLogNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WriteLogNodeTest {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean enableWal;

    @Before
    public void setUp() {
        this.enableWal = this.config.isEnableWal();
        this.config.setEnableWal(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setEnableWal(this.enableWal);
    }

    @Test
    public void testWriteLogAndSync() throws IOException, IllegalPathException {
        ByteBuffer[] array;
        String identifier = "root.logTestDevice";
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode(identifier);
        logNode.initBuffer(byteBuffers);
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath(identifier), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath(identifier + ".s1"));
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        Object[] columns = new Object[]{new double[4], new long[4], new Binary[4], new boolean[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0;
            ((long[])columns[1])[r] = 1L;
            ((Binary[])columns[2])[r] = new Binary("hh" + r);
            ((boolean[])columns[3])[r] = false;
        }
        InsertTabletPlan tabletPlan = new InsertTabletPlan(new PartialPath(identifier), new String[]{"s1", "s2", "s3", "s4"}, dataTypes);
        tabletPlan.setTimes(times);
        tabletPlan.setColumns(columns);
        tabletPlan.setRowCount(times.length);
        tabletPlan.setStart(0);
        tabletPlan.setEnd(4);
        tabletPlan.markFailedMeasurementInsertion(1, new Exception());
        logNode.write((PhysicalPlan)bwInsertPlan);
        logNode.write((PhysicalPlan)deletePlan);
        logNode.write((PhysicalPlan)tabletPlan);
        logNode.close();
        File walFile = new File(this.config.getWalDir() + File.separator + identifier + File.separator + "wal1");
        TestCase.assertTrue((boolean)walFile.exists());
        ILogReader reader = logNode.getLogReader();
        TestCase.assertEquals((Object)bwInsertPlan, (Object)reader.next());
        TestCase.assertEquals((Object)deletePlan, (Object)reader.next());
        InsertTabletPlan newPlan = (InsertTabletPlan)reader.next();
        TestCase.assertEquals((int)newPlan.getMeasurements().length, (int)3);
        reader.close();
        for (ByteBuffer byteBuffer : array = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    @Test
    public void testNotifyFlush() throws IOException, IllegalPathException {
        ByteBuffer[] array;
        String identifier = "root.logTestDevice";
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode(identifier);
        logNode.initBuffer(byteBuffers);
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath(identifier), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath(identifier + ".s1"));
        logNode.write((PhysicalPlan)bwInsertPlan);
        logNode.notifyStartFlush();
        logNode.write((PhysicalPlan)deletePlan);
        logNode.notifyStartFlush();
        ILogReader logReader = logNode.getLogReader();
        TestCase.assertEquals((Object)bwInsertPlan, (Object)logReader.next());
        TestCase.assertEquals((Object)deletePlan, (Object)logReader.next());
        logReader.close();
        logNode.notifyEndFlush();
        logReader = logNode.getLogReader();
        TestCase.assertEquals((Object)deletePlan, (Object)logReader.next());
        logReader.close();
        logNode.notifyEndFlush();
        logReader = logNode.getLogReader();
        TestCase.assertFalse((boolean)logReader.hasNext());
        logReader.close();
        for (ByteBuffer byteBuffer : array = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    @Test
    public void testSyncThreshold() throws IOException, IllegalPathException {
        ByteBuffer[] array;
        int flushWalThreshold = this.config.getFlushWalThreshold();
        this.config.setFlushWalThreshold(2);
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode("root.logTestDevice");
        logNode.initBuffer(byteBuffers);
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("root.logTestDevice"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath("root.logTestDevice.s1"));
        logNode.write((PhysicalPlan)bwInsertPlan);
        File walFile = new File(this.config.getWalDir() + File.separator + "root.logTestDevice" + File.separator + "wal1");
        TestCase.assertFalse((boolean)walFile.exists());
        logNode.write((PhysicalPlan)deletePlan);
        System.out.println("Waiting for wal file to be created");
        while (!walFile.exists()) {
        }
        TestCase.assertTrue((boolean)walFile.exists());
        for (ByteBuffer byteBuffer : array = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
        this.config.setFlushWalThreshold(flushWalThreshold);
    }

    @Test
    public void testDelete() throws IOException, IllegalPathException {
        ByteBuffer[] array;
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode("root.logTestDevice");
        logNode.initBuffer(byteBuffers);
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("logTestDevice"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath("root.logTestDevice.s1"));
        logNode.write((PhysicalPlan)bwInsertPlan);
        logNode.write((PhysicalPlan)deletePlan);
        logNode.forceSync();
        File walFile = new File(this.config.getWalDir() + File.separator + "root.logTestDevice" + File.separator + "wal1");
        System.out.println("Waiting for wal to be created");
        while (!walFile.exists()) {
        }
        TestCase.assertTrue((boolean)new File(logNode.getLogDirectory()).exists());
        for (ByteBuffer byteBuffer : array = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
        TestCase.assertFalse((boolean)new File(logNode.getLogDirectory()).exists());
    }

    @Test
    public void testOverSizedWAL() throws IOException, IllegalPathException {
        ByteBuffer[] array;
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode("root.logTestDevice.oversize");
        logNode.initBuffer(byteBuffers);
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("root.logTestDevice.oversize"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", new String(new char[0x4100000]), "false"});
        boolean caught = false;
        try {
            logNode.write((PhysicalPlan)bwInsertPlan);
        }
        catch (IOException e) {
            caught = true;
        }
        TestCase.assertTrue((boolean)caught);
        for (ByteBuffer byteBuffer : array = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }
}

