/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IoTDBLogFileSizeTest {
    private boolean skip = true;
    private int groupSize;
    private long runtime = 600000L;
    private String[] setUpSqls = new String[]{"SET STORAGE GROUP TO root.logFileTest.seq", "SET STORAGE GROUP TO root.logFileTest.unsequence", "CREATE TIMESERIES root.logFileTest.seq.val WITH DATATYPE=INT32, ENCODING=PLAIN", "CREATE TIMESERIES root.logFileTest.unsequence.val WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.logFileTest.unsequence(timestamp,val) VALUES (1000000000, 0)"};
    private String[] tearDownSqls = new String[]{"DELETE TIMESERIES root.logFileTest.*"};

    @Before
    public void setUp() throws Exception {
        if (this.skip) {
            return;
        }
        this.groupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(0x800000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(0x800000L);
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        this.executeSQL(this.setUpSqls);
    }

    @After
    public void tearDown() throws Exception {
        if (this.skip) {
            return;
        }
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(this.groupSize);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)this.groupSize);
        this.executeSQL(this.tearDownSqls);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSeqFile() throws InterruptedException {
        if (this.skip) {
            return;
        }
        long[] maxLength = new long[]{0L};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        Thread writeThread = new Thread(() -> {
            int cnt = 0;
            try {
                Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                 Statement statement = connection.createStatement();){
                while (!Thread.interrupted()) {
                    String sql = String.format("INSERT INTO root.logFileTest.seq(timestamp,val) VALUES (%d, %d)", ++cnt, cnt);
                    statement.execute(sql);
                    WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode("root.logFileTest.seq-seq", () -> buffers);
                    File bufferWriteWALFile = new File(logNode.getLogDirectory() + File.separator + "wal");
                    if (!bufferWriteWALFile.exists() || bufferWriteWALFile.length() <= maxLength[0]) continue;
                    maxLength[0] = bufferWriteWALFile.length();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        writeThread.start();
        Thread.sleep(this.runtime);
        writeThread.interrupt();
        while (writeThread.isAlive()) {
        }
        for (ByteBuffer byteBuffer : buffers) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    @Test
    public void testUnsequence() throws InterruptedException {
        if (this.skip) {
            return;
        }
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        long[] maxLength = new long[]{0L};
        Thread writeThread = new Thread(() -> {
            int cnt = 0;
            try {
                Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                 Statement statement = connection.createStatement();){
                while (!Thread.interrupted()) {
                    String sql = String.format("INSERT INTO root.logFileTest.unsequence(timestamp,val) VALUES (%d, %d)", ++cnt, cnt);
                    statement.execute(sql);
                    WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode("root.logFileTest.unsequence-unseq", () -> buffers);
                    File WALFile = new File(logNode.getLogDirectory() + File.separator + "wal");
                    if (!WALFile.exists() || WALFile.length() <= maxLength[0]) continue;
                    maxLength[0] = WALFile.length();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        writeThread.start();
        Thread.sleep(this.runtime);
        writeThread.interrupt();
        while (writeThread.isAlive()) {
        }
        for (ByteBuffer byteBuffer : buffers) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    private void executeSQL(String[] sqls) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

