/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrecisionTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDoublePrecision1() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.turbine1");
            statement.execute("create timeseries root.turbine1.d1.s1 with datatype=DOUBLE, encoding=PLAIN, compression=SNAPPY");
            statement.execute("insert into root.turbine1.d1(timestamp,s1) values(1,1.2345678)");
            ResultSet resultSet = statement.executeQuery("select * from root.turbine1");
            String str = "1.2345678";
            while (resultSet.next()) {
                Assert.assertEquals((Object)str, (Object)resultSet.getString("root.turbine1.d1.s1"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDoublePrecision2() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.turbine1");
            statement.execute("create timeseries root.turbine1.d1.s1 with datatype=DOUBLE, encoding=RLE, compression=SNAPPY");
            statement.execute("insert into root.turbine1.d1(timestamp,s1) values(1,1.2345678)");
            ResultSet resultSet = statement.executeQuery("select * from root.turbine1");
            String str = "1.23";
            while (resultSet.next()) {
                Assert.assertEquals((Object)str, (Object)resultSet.getString("root.turbine1.d1.s1"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFloatPrecision1() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.turbine1");
            statement.execute("create timeseries root.turbine1.d1.s1 with datatype=FLOAT, encoding=PLAIN, compression=SNAPPY");
            statement.execute("insert into root.turbine1.d1(timestamp,s1) values(1,1.2345678)");
            ResultSet resultSet = statement.executeQuery("select * from root.turbine1");
            String str = "1.2345678";
            while (resultSet.next()) {
                Assert.assertEquals((Object)str, (Object)resultSet.getString("root.turbine1.d1.s1"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFloatPrecision2() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.turbine1");
            statement.execute("create timeseries root.turbine1.d1.s1 with datatype=FLOAT, encoding=RLE, compression=SNAPPY");
            statement.execute("insert into root.turbine1.d1(timestamp,s1) values(1,1.2345678)");
            ResultSet resultSet = statement.executeQuery("select * from root.turbine1");
            String str = "1.23";
            while (resultSet.next()) {
                Assert.assertEquals((Object)str, (Object)resultSet.getString("root.turbine1.d1.s1"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

