/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class LongTVListTest {
    @Test
    public void testLongTVList1() {
        long i;
        LongTVList tvList = new LongTVList();
        for (i = 0L; i < 1000L; ++i) {
            tvList.putLong(i, i);
        }
        tvList.sort();
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getLong((int)i));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testLongTVList2() {
        long i;
        LongTVList tvList = new LongTVList();
        for (i = 1000L; i >= 0L; --i) {
            tvList.putLong(i, i);
        }
        tvList.sort();
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getLong((int)i));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testLongTVList3() {
        long i;
        Random random = new Random();
        LongTVList tvList = new LongTVList();
        ArrayList<TimeValuePair> inputs = new ArrayList<TimeValuePair>();
        for (i = 0L; i < 10000L; ++i) {
            long time = random.nextInt(10000);
            long value = random.nextInt(10000);
            tvList.putLong(time, value);
            inputs.add(new TimeValuePair(time, (TsPrimitiveType)new TsPrimitiveType.TsLong(value)));
        }
        tvList.sort();
        inputs.sort(TimeValuePair::compareTo);
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((long)((TimeValuePair)inputs.get((int)i)).getTimestamp(), (long)tvList.getTime((int)i));
            Assert.assertEquals((long)((TimeValuePair)inputs.get((int)i)).getValue().getLong(), (long)tvList.getLong((int)i));
        }
    }

    @Test
    public void testLongTVLists() {
        long i;
        LongTVList tvList = new LongTVList();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            longList.add(i);
        }
        tvList.putLongs(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Long[])longList.toArray(new Long[0])), 0, 1000);
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((long)((long)tvList.size - i), (long)tvList.getLong((int)i));
            Assert.assertEquals((long)((long)tvList.size - i), (long)tvList.getTime((int)i));
        }
    }
}

