/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.FloatTVList;
import org.junit.Assert;
import org.junit.Test;

public class FloatTVListTest {
    public static float delta = 0.001f;

    @Test
    public void testFloatTVList1() {
        int i;
        FloatTVList tvList = new FloatTVList();
        for (i = 0; i < 1000; ++i) {
            tvList.putFloat((long)i, (float)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.size; ++i) {
            Assert.assertEquals((float)i, (float)tvList.getFloat(i), (float)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testFloatTVList2() {
        int i;
        FloatTVList tvList = new FloatTVList();
        for (i = 1000; i >= 0; --i) {
            tvList.putFloat((long)i, (float)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.size; ++i) {
            Assert.assertEquals((float)i, (float)tvList.getFloat(i), (float)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testFloatTVLists() {
        long i;
        FloatTVList tvList = new FloatTVList();
        ArrayList<Float> floatList = new ArrayList<Float>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            floatList.add(Float.valueOf(i));
        }
        tvList.putFloats(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Float[])floatList.toArray(new Float[0]), (float)0.0f), 0, 1000);
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((float)((float)tvList.size - (float)i), (float)tvList.getFloat((int)i), (float)delta);
            Assert.assertEquals((long)((long)tvList.size - i), (long)tvList.getTime((int)i));
        }
    }
}

