/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.DoubleTVList;
import org.junit.Assert;
import org.junit.Test;

public class DoubleTVListTest {
    public static double delta = 0.001;

    @Test
    public void testDoubleTVList1() {
        int i;
        DoubleTVList tvList = new DoubleTVList();
        for (i = 0; i < 1000; ++i) {
            tvList.putDouble((long)i, (double)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.size; ++i) {
            Assert.assertEquals((double)i, (double)tvList.getDouble(i), (double)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testDoubleTVList2() {
        int i;
        DoubleTVList tvList = new DoubleTVList();
        for (i = 1000; i >= 0; --i) {
            tvList.putDouble((long)i, (double)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.size; ++i) {
            Assert.assertEquals((double)i, (double)tvList.getDouble(i), (double)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testDoubleTVLists() {
        long i;
        DoubleTVList tvList = new DoubleTVList();
        ArrayList<Double> doubleList = new ArrayList<Double>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            doubleList.add(Double.valueOf(i));
        }
        tvList.putDoubles(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Double[])doubleList.toArray(new Double[0]), (double)0.0), 0, 1000);
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((double)((double)tvList.size - (double)i), (double)tvList.getDouble((int)i), (double)delta);
            Assert.assertEquals((long)((long)tvList.size - i), (long)tvList.getTime((int)i));
        }
    }
}

