/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.BooleanTVList;
import org.junit.Assert;
import org.junit.Test;

public class BooleanTVListTest {
    @Test
    public void testBooleanTVList() {
        int i;
        BooleanTVList tvList = new BooleanTVList();
        for (i = 0; i < 50; ++i) {
            tvList.putBoolean((long)i, true);
        }
        for (i = 50; i < 100; ++i) {
            tvList.putBoolean((long)i, false);
        }
        for (i = 0; i < tvList.size / 2; ++i) {
            Assert.assertTrue((boolean)tvList.getBoolean(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
        for (i = tvList.size / 2 + 1; i < tvList.size; ++i) {
            Assert.assertFalse((boolean)tvList.getBoolean(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testBooleanTVLists() {
        long i;
        BooleanTVList tvList = new BooleanTVList();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            booleanList.add(i % 2L == 0L);
        }
        tvList.putBooleans(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Boolean[])booleanList.toArray(new Boolean[0])), 0, 1000);
        for (i = 0L; i < (long)tvList.size; ++i) {
            Assert.assertEquals((long)((long)tvList.size - i), (long)tvList.getTime((int)i));
        }
    }
}

