/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.ReadOnlyTsFile;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileRewriteToolTest {
    private String path = null;
    private IoTDBConfig config;
    private boolean originEnablePartition;
    private long originPartitionInterval;
    private final boolean newEnablePartition = true;
    private final long newPartitionInterval = 3600000L;
    private final long maxTimestamp = 100000000L;
    private final String folder = "target" + File.separator + "split";
    private final String STORAGE_GROUP = "root.sg_0";
    private final String DEVICE1 = "root.sg_0.device_1";
    private final String DEVICE2 = "root.sg_0.device_2";
    private final String SENSOR1 = "sensor_1";
    private final String SENSOR2 = "sensor_2";
    private final long VALUE_OFFSET = 1L;
    private final IPlanExecutor queryExecutor = new PlanExecutor();
    private final Planner processor = new Planner();

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.config = IoTDBDescriptor.getInstance().getConfig();
        this.originEnablePartition = this.config.isEnablePartition();
        this.originPartitionInterval = this.config.getPartitionInterval();
        this.config.setEnablePartition(true);
        this.config.setPartitionInterval(3600000L);
        StorageEngine.setEnablePartition((boolean)true);
        StorageEngine.setTimePartitionInterval((long)3600000L);
        File f = new File(this.folder);
        if (!f.exists()) {
            boolean success = f.mkdir();
            Assert.assertTrue((boolean)success);
        }
        this.path = this.folder + File.separator + System.currentTimeMillis() + "-" + 0 + "-0-0.tsfile";
    }

    @After
    public void tearDown() {
        File f = new File(this.path);
        if (f.exists()) {
            boolean deleteSuccess = f.delete();
            Assert.assertTrue((boolean)deleteSuccess);
        }
        this.config.setEnablePartition(this.originEnablePartition);
        this.config.setPartitionInterval(this.originPartitionInterval);
        StorageEngine.setEnablePartition((boolean)this.originEnablePartition);
        StorageEngine.setTimePartitionInterval((long)this.originPartitionInterval);
        File directory = new File(this.folder);
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            EnvironmentUtils.cleanEnv();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void splitOneTsfileWithOneDeviceOneSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void splitOneTsfileWithOneDeviceTwoSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        sensors.add("sensor_2");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void splitOneTsfileWithTwoDeviceTwoSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        sensors.add("sensor_2");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        deviceSensorsMap.put("root.sg_0.device_2", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void loadFileTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        String sql = "load \"" + this.path + "\" true";
        try {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void loadFileWithOnlyOnePageTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFileWithOnlyOnePage(deviceSensorsMap);
        String sql = "load \"" + this.path + "\" true";
        try {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void splitFileAndQueryCheck(HashMap<String, List<String>> deviceSensorsMap) {
        File tsFile = new File(this.path);
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        ArrayList splitResource = new ArrayList();
        try {
            TsFileRewriteTool.rewriteTsFile((TsFileResource)tsFileResource, splitResource);
        }
        catch (IOException | WriteProcessException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)28L, (long)splitResource.size());
        for (int i = 0; i < splitResource.size(); ++i) {
            try {
                this.queryAndCheckTsFileWithOneDevice(((TsFileResource)splitResource.get(i)).getTsFilePath(), i, deviceSensorsMap);
                long partitionId = ((TsFileResource)splitResource.get(i)).getTimePartition();
                Assert.assertEquals((long)i, (long)partitionId);
                continue;
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void createOneTsFileWithOnlyOnePage(HashMap<String, List<String>> deviceSensorsMap) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    for (String string : entry.getValue()) {
                        tsFileWriter.registerTimeseries(new Path(device, string), new MeasurementSchema(string, TSDataType.INT64, TSEncoding.RLE));
                    }
                }
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            int count = 0;
            long timestamp = 1L;
            while (count != 2) {
                ++count;
                for (Map.Entry entry : deviceSensorsMap.entrySet()) {
                    String device = (String)entry.getKey();
                    TSRecord tsRecord = new TSRecord(timestamp, device);
                    for (String sensor : (List)entry.getValue()) {
                        LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp + 1L);
                        tsRecord.addTuple((DataPoint)dataPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
                tsFileWriter.flushAllChunkGroups();
                timestamp += 3600000L;
            }
            tsFileWriter.close();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void createOneTsFile(HashMap<String, List<String>> deviceSensorsMap) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    for (String sensor : entry.getValue()) {
                        tsFileWriter.registerTimeseries(new Path(device, sensor), new MeasurementSchema(sensor, TSDataType.INT64, TSEncoding.RLE));
                    }
                }
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            for (long timestamp = 0L; timestamp < 100000000L; timestamp += 1000L) {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    TSRecord tsRecord = new TSRecord(timestamp, device);
                    for (String sensor : entry.getValue()) {
                        LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp + 1L);
                        tsRecord.addTuple((DataPoint)dataPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
            }
            tsFileWriter.flushAllChunkGroups();
            tsFileWriter.close();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void queryAndCheckTsFileWithOneDevice(String tsFilePath, int index, HashMap<String, List<String>> deviceSensorsMap) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFilePath);
             ReadOnlyTsFile readTsFile = new ReadOnlyTsFile(reader);){
            ArrayList<Path> paths = new ArrayList<Path>();
            int totalSensorCount = 0;
            for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                String device = entry.getKey();
                for (String sensor : entry.getValue()) {
                    ++totalSensorCount;
                    paths.add(new Path(device, sensor));
                }
            }
            QueryExpression queryExpression = QueryExpression.create(paths, null);
            QueryDataSet queryDataSet = readTsFile.query(queryExpression);
            long count = 0L;
            while (queryDataSet.hasNext()) {
                RowRecord rowRecord = queryDataSet.next();
                Assert.assertEquals((long)totalSensorCount, (long)rowRecord.getFields().size());
                long timeStamp = rowRecord.getTimestamp();
                Assert.assertEquals((long)((long)index * 3600000L + count), (long)timeStamp);
                for (int i = 0; i < totalSensorCount; ++i) {
                    Assert.assertEquals((long)(timeStamp + 1L), (long)((Field)rowRecord.getFields().get(i)).getLongV());
                }
                count += 1000L;
            }
        }
    }
}

