/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class SerializeUtilsTest {
    @Test
    public void serdesStringTest() {
        String str = "abcd%+/123\n\t";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serialize((String)str, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals((Object)str, (Object)SerializeUtils.deserializeString((ByteBuffer)buffer));
    }

    @Test
    public void serdesStringListTest() {
        List<String> slist = Arrays.asList("abc", "123", "y87@", "9+&d\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeStringList(slist, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals(slist, (Object)SerializeUtils.deserializeStringList((ByteBuffer)buffer));
    }

    @Test
    public void serdesIntListTest() {
        List<Integer> intlist = Arrays.asList(12, 34, 567, 8910);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeIntList(intlist, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        ArrayList anotherIntlist = new ArrayList();
        SerializeUtils.deserializeIntList(anotherIntlist, (ByteBuffer)buffer);
        Assert.assertEquals(intlist, anotherIntlist);
    }

    @Test
    public void serdesIntSetTest() {
        List<Integer> intlist = Arrays.asList(12, 34, 567, 8910);
        TreeSet<Integer> intSet = new TreeSet<Integer>(intlist);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeIntSet(intSet, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        TreeSet anotherIntlist = new TreeSet();
        SerializeUtils.deserializeIntSet(anotherIntlist, (ByteBuffer)buffer);
        Assert.assertEquals(intSet, anotherIntlist);
    }

    @Test
    public void serdesINT32BatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.INT32);
        int ivalue = 0;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)ivalue);
            ++ivalue;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesINT64BatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.INT64);
        long lvalue = 0L;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)lvalue);
            ++lvalue;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesFLOATBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.FLOAT);
        float fvalue = 0.0f;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)Float.valueOf(fvalue));
            fvalue += 1.0f;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesDOUBLEBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.DOUBLE);
        double dvalue = 0.0;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)dvalue);
            dvalue += 1.0;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesBOOLEANBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.BOOLEAN);
        batchData.putAnObject(1L, (Object)true);
        batchData.putAnObject(2L, (Object)false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesTEXTBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.TEXT);
        String svalue = "";
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)Binary.valueOf((String)svalue));
            svalue = svalue + String.valueOf(time);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesTVPairTest() {
        ArrayList<TimeValuePair> TVPairs = new ArrayList<TimeValuePair>();
        TimeValuePair p1 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)true));
        TVPairs.add(p1);
        TimeValuePair p2 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)1));
        TVPairs.add(p2);
        TimeValuePair p3 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)1L));
        TVPairs.add(p3);
        TimeValuePair p4 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(1.0f)));
        TVPairs.add(p4);
        TimeValuePair p5 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)1.0));
        TVPairs.add(p5);
        TimeValuePair p6 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)Binary.valueOf((String)"a")));
        TVPairs.add(p6);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        for (TimeValuePair tv : TVPairs) {
            SerializeUtils.serializeTVPair((TimeValuePair)tv, (DataOutputStream)outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            Assert.assertEquals((Object)tv, (Object)SerializeUtils.deserializeTVPair((ByteBuffer)buffer));
            baos.reset();
        }
    }

    @Test
    public void serdesTVPairsTest() {
        ArrayList<List<TimeValuePair>> TVPairs = new ArrayList<List<TimeValuePair>>();
        TimeValuePair p1 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)true));
        TVPairs.add(Collections.singletonList(p1));
        TimeValuePair p2 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)1));
        TVPairs.add(Collections.singletonList(p2));
        TimeValuePair p3 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)1L));
        TVPairs.add(Collections.singletonList(p3));
        TimeValuePair p4 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(1.0f)));
        TVPairs.add(Collections.singletonList(p4));
        TimeValuePair p5 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)1.0));
        TVPairs.add(Collections.singletonList(p5));
        TimeValuePair p6 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)Binary.valueOf((String)"a")));
        TVPairs.add(Collections.singletonList(p6));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        for (List list : TVPairs) {
            SerializeUtils.serializeTVPairs((List)list, (DataOutputStream)outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            Assert.assertEquals((Object)list, (Object)SerializeUtils.deserializeTVPairs((ByteBuffer)buffer));
            baos.reset();
        }
    }

    @Test
    public void serdesObjectTest() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeObject((Object)1, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals((Object)1, (Object)SerializeUtils.deserializeObject((ByteBuffer)buffer));
    }

    @Test
    public void serdesObjectsTest() {
        Object[] objects = new Object[]{1, "2", 3.0};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeObjects((Object[])objects, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertArrayEquals((Object[])objects, (Object[])SerializeUtils.deserializeObjects((ByteBuffer)buffer));
    }

    @Test
    public void serdesLongsTest() {
        long[] array = new long[]{1L, 10L, 100L, 1000L, 10000L};
        ByteBuffer buffer = SerializeUtils.serializeLongs((long[])array);
        Assert.assertArrayEquals((long[])array, (long[])SerializeUtils.deserializeLongs((ByteBuffer)buffer));
    }
}

