/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.junit.Assert;
import org.junit.Test;

public class MemUtilsTest {
    @Test
    public void getRecordSizeTest() {
        Assert.assertEquals((long)12L, (long)MemUtils.getRecordSize((TSDataType)TSDataType.INT32, (Object)10, (boolean)true));
        Assert.assertEquals((long)16L, (long)MemUtils.getRecordSize((TSDataType)TSDataType.INT64, (Object)10, (boolean)true));
        Assert.assertEquals((long)12L, (long)MemUtils.getRecordSize((TSDataType)TSDataType.FLOAT, (Object)10.0, (boolean)true));
        Assert.assertEquals((long)16L, (long)MemUtils.getRecordSize((TSDataType)TSDataType.DOUBLE, (Object)10.0, (boolean)true));
        Assert.assertEquals((long)8L, (long)MemUtils.getRecordSize((TSDataType)TSDataType.TEXT, (Object)"10", (boolean)false));
    }

    @Test
    public void getRecordSizeWithInsertPlanTest() throws IllegalPathException {
        PartialPath device = new PartialPath("root.sg.d1");
        String[] measurements = new String[]{"s1", "s2", "s3", "s4", "s5"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        int sizeSum = 0;
        dataTypes.add(TSDataType.INT32.ordinal());
        sizeSum += 8 + TSDataType.INT32.getDataTypeSize();
        dataTypes.add(TSDataType.INT64.ordinal());
        sizeSum += 8 + TSDataType.INT64.getDataTypeSize();
        dataTypes.add(TSDataType.FLOAT.ordinal());
        sizeSum += 8 + TSDataType.FLOAT.getDataTypeSize();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        sizeSum += 8 + TSDataType.DOUBLE.getDataTypeSize();
        dataTypes.add(TSDataType.TEXT.ordinal());
        InsertTabletPlan insertPlan = new InsertTabletPlan(device, measurements, dataTypes);
        Assert.assertEquals((long)(sizeSum += TSDataType.TEXT.getDataTypeSize()), (long)MemUtils.getRecordSize((InsertTabletPlan)insertPlan, (int)0, (int)1, (boolean)false));
    }

    @Test
    public void getMemSizeTest() {
        int totalSize = 0;
        String device = "root.sg.d1";
        TSRecord record = new TSRecord(0L, device);
        IntDataPoint point1 = new IntDataPoint("s1", 1);
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s1") + 20L), (long)MemUtils.getDataPointMem((DataPoint)point1));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point1));
        record.addTuple((DataPoint)point1);
        LongDataPoint point2 = new LongDataPoint("s2", 1L);
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s2") + 24L), (long)MemUtils.getDataPointMem((DataPoint)point2));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point2));
        record.addTuple((DataPoint)point2);
        FloatDataPoint point3 = new FloatDataPoint("s3", 1.0f);
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s3") + 20L), (long)MemUtils.getDataPointMem((DataPoint)point3));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point3));
        record.addTuple((DataPoint)point3);
        DoubleDataPoint point4 = new DoubleDataPoint("s4", 1.0);
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s4") + 24L), (long)MemUtils.getDataPointMem((DataPoint)point4));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point4));
        record.addTuple((DataPoint)point4);
        BooleanDataPoint point5 = new BooleanDataPoint("s5", true);
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s5") + 17L), (long)MemUtils.getDataPointMem((DataPoint)point5));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point5));
        record.addTuple((DataPoint)point5);
        StringDataPoint point6 = new StringDataPoint("s5", Binary.valueOf((String)"123"));
        Assert.assertEquals((long)(MemUtils.getStringMem((String)"s6") + 129L), (long)MemUtils.getDataPointMem((DataPoint)point6));
        totalSize = (int)((long)totalSize + MemUtils.getDataPointMem((DataPoint)point6));
        record.addTuple((DataPoint)point6);
        totalSize = (int)((long)totalSize + ((long)(8 * record.dataPointList.size()) + MemUtils.getStringMem((String)device) + 16L));
        Assert.assertEquals((long)totalSize, (long)MemUtils.getTsRecordMem((TSRecord)record));
    }

    @Test
    public void bytesCntToStrTest() {
        String r = "4 GB 877 MB 539 KB 903 B";
        Assert.assertEquals((Object)r, (Object)MemUtils.bytesCntToStr((long)5215121287L));
    }
}

