/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilePathUtilsTest {
    private static final String storageGroupName = "root.group_9";
    private static final String virtualSgName = "1";
    private static final long partitionId = 0L;
    private static final String tsFileName = "1611199237113-4-0.tsfile";
    private static final String fullPath = "target" + File.separator + "root.group_9" + File.separator + "1" + File.separator + 0L + File.separator + "1611199237113-4-0.tsfile";
    private File tsFile;

    @Before
    public void setUp() {
        this.tsFile = new File(fullPath);
        boolean success = false;
        try {
            FileUtils.forceMkdirParent((File)this.tsFile);
            success = this.tsFile.createNewFile();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void getLogicalSgNameAndTimePartitionIdPairTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        Pair sgNameAndTimePartitionIdPair = FilePathUtils.getLogicalSgNameAndTimePartitionIdPair((TsFileResource)tsFileResource);
        Assert.assertEquals((Object)storageGroupName, (Object)sgNameAndTimePartitionIdPair.left);
        Assert.assertEquals((long)0L, (long)((Long)sgNameAndTimePartitionIdPair.right));
    }

    @Test
    public void getLogicalStorageGroupNameTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        String tmpSgName = FilePathUtils.getLogicalStorageGroupName((TsFileResource)tsFileResource);
        Assert.assertEquals((Object)storageGroupName, (Object)tmpSgName);
    }

    @Test
    public void getVirtualStorageGroupNameTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        String tmpVirtualSgName = FilePathUtils.getVirtualStorageGroupId((TsFileResource)tsFileResource);
        Assert.assertEquals((Object)virtualSgName, (Object)tmpVirtualSgName);
    }

    @Test
    public void getTimePartitionIdTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        long tmpTimePartitionId = FilePathUtils.getTimePartitionId((TsFileResource)tsFileResource);
        Assert.assertEquals((long)0L, (long)tmpTimePartitionId);
    }

    @Test
    public void getTsFileNameWithoutHardLinkTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        TsFileResource newTsFileResource = tsFileResource.createHardlink();
        String tsFileNameWithoutHardLink = FilePathUtils.getTsFileNameWithoutHardLink((TsFileResource)newTsFileResource);
        Assert.assertEquals((Object)tsFileName, (Object)tsFileNameWithoutHardLink);
        Assert.assertTrue((boolean)newTsFileResource.getTsFile().delete());
    }

    @Test
    public void getTsFilePrefixPathTest() {
        TsFileResource tsFileResource = new TsFileResource();
        tsFileResource.setFile(this.tsFile);
        String tsFilePrefixPath = FilePathUtils.getTsFilePrefixPath((TsFileResource)tsFileResource);
        String exceptPrefixPath = storageGroupName + File.separator + virtualSgName + File.separator + 0L;
        Assert.assertEquals((Object)exceptPrefixPath, (Object)tsFilePrefixPath);
    }

    @After
    public void tearDown() {
        Assert.assertTrue((boolean)this.tsFile.delete());
    }
}

