/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.SystemCheckException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.tools.WalChecker;
import org.apache.iotdb.db.writelog.io.LogWriter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class WalCheckerTest {
    @Test
    public void testNoDir() {
        WalChecker checker = new WalChecker("no such dir");
        boolean caught = false;
        try {
            checker.doCheck();
        }
        catch (SystemCheckException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testEmpty() throws IOException, SystemCheckException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("root"));
        tempRoot.mkdir();
        try {
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertTrue((boolean)checker.doCheck().isEmpty());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalCheck() throws IOException, SystemCheckException, IllegalPathException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("root"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File subDir = new File(tempRoot, "storage_group" + i);
                subDir.mkdir();
                LogWriter logWriter = new LogWriter(subDir.getPath() + File.separator + "wal", IoTDBDescriptor.getInstance().getConfig().getForceWalPeriodInMs() == 0L);
                ByteBuffer binaryPlans = ByteBuffer.allocate(65536);
                String deviceId = "device1";
                String[] measurements = new String[]{"s1", "s2", "s3"};
                TSDataType[] types = new TSDataType[]{TSDataType.INT64, TSDataType.INT64, TSDataType.INT64};
                String[] values = new String[]{"5", "6", "7"};
                for (int j = 0; j < 10; ++j) {
                    new InsertRowPlan(new PartialPath(deviceId), (long)j, measurements, types, values).serialize(binaryPlans);
                }
                binaryPlans.flip();
                logWriter.write(binaryPlans);
                logWriter.force();
                logWriter.close();
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertTrue((boolean)checker.doCheck().isEmpty());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbnormalCheck() throws IOException, SystemCheckException, IllegalPathException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("root"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File subDir = new File(tempRoot, "storage_group" + i);
                subDir.mkdir();
                LogWriter logWriter = new LogWriter(subDir.getPath() + File.separator + "wal", IoTDBDescriptor.getInstance().getConfig().getForceWalPeriodInMs() == 0L);
                ByteBuffer binaryPlans = ByteBuffer.allocate(65536);
                String deviceId = "device1";
                String[] measurements = new String[]{"s1", "s2", "s3"};
                TSDataType[] types = new TSDataType[]{TSDataType.INT64, TSDataType.INT64, TSDataType.INT64};
                String[] values = new String[]{"5", "6", "7"};
                for (int j = 0; j < 10; ++j) {
                    new InsertRowPlan(new PartialPath(deviceId), (long)j, measurements, types, values).serialize(binaryPlans);
                }
                if (i > 2) {
                    binaryPlans.put("not a wal".getBytes());
                }
                logWriter.write(binaryPlans);
                logWriter.force();
                logWriter.close();
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertEquals((long)2L, (long)checker.doCheck().size());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneDamagedCheck() throws IOException, SystemCheckException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("root"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File subDir = new File(tempRoot, "storage_group" + i);
                subDir.mkdir();
                try (FileOutputStream fileOutputStream = new FileOutputStream(new File(subDir, "wal"));){
                    fileOutputStream.write(i);
                    continue;
                }
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertEquals((long)5L, (long)checker.doCheck().size());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }
}

