/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.tools.TsFileSketchTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileSketchToolTest {
    String path = "test.tsfile";
    String sketchOut = "sketch.out";
    String device = "root.device_0";

    @Before
    public void setUp() throws Exception {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            if (f.exists() && !f.delete()) {
                throw new RuntimeException("can not delete " + f.getAbsolutePath());
            }
            Schema schema = new Schema();
            String sensorPrefix = "sensor_";
            int rowNum = 1000000;
            int sensorNum = 10;
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < sensorNum; ++i) {
                MeasurementSchema measurementSchema = new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF);
                measurementSchemas.add(measurementSchema);
                schema.registerTimeseries(new Path(this.device, sensorPrefix + (i + 1)), new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF));
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(f, schema);){
                Tablet tablet = new Tablet(this.device, measurementSchemas);
                long[] timestamps = tablet.timestamps;
                Object[] values = tablet.values;
                long timestamp = 1L;
                long value = 1000000L;
                int r = 0;
                while (r < rowNum) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (int i = 0; i < sensorNum; ++i) {
                        long[] sensor = (long[])values[i];
                        sensor[row] = value;
                    }
                    if (tablet.rowSize == tablet.getMaxRowNumber()) {
                        tsFileWriter.write(tablet);
                        tablet.reset();
                    }
                    ++r;
                    ++value;
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("meet error in TsFileWrite with tablet", e);
        }
    }

    @Test
    public void tsFileSketchToolTest() {
        TsFileSketchTool tool = new TsFileSketchTool();
        String[] args = new String[]{this.path, this.sketchOut};
        try {
            TsFileSketchTool.main((String[])args);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        try {
            FileUtils.forceDelete((File)new File(this.path));
            FileUtils.forceDelete((File)new File(this.sketchOut));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

