/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.tools.mlog.MLogParser;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogParserTest {
    private static final Logger logger = LoggerFactory.getLogger(MLogParserTest.class);

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.deleteOnExit();
        file = new File("target" + File.separator + "tmp" + File.separator + "text.snapshot");
        file.deleteOnExit();
    }

    public void prepareData() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
                    try {
                        plan.setPath(new PartialPath("root.sg" + i + ".device" + j + ".s" + k));
                        plan.setDataType(TSDataType.INT32);
                        plan.setEncoding(TSEncoding.PLAIN);
                        plan.setCompressor(CompressionType.GZIP);
                        IoTDB.metaManager.createTimeseries(plan);
                        continue;
                    }
                    catch (MetadataException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.ln.cc"));
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.sgcc"));
            IoTDB.metaManager.setTTL(new PartialPath("root.sgcc"), 1234L);
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg1.device1.s1"));
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            paths.add(new PartialPath("root.ln.cc"));
            IoTDB.metaManager.deleteStorageGroups(paths);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag1", "value1");
            IoTDB.metaManager.addTags(tags, new PartialPath("root.sg1.device1.s2"));
            IoTDB.metaManager.changeAlias(new PartialPath("root.sg1.device1.s3"), "hello");
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testParseMLog() throws IOException {
        this.prepareData();
        IoTDB.metaManager.flushAllMlogForTest();
        try {
            MLogParser.parseFromFile((String)(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mlog.bin"), (String)("target" + File.separator + "tmp" + File.separator + "text.mlog"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.mlog"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != 108) {
                for (String content : lines) {
                    logger.info(content);
                }
            }
            Assert.assertEquals((long)108L, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSnapshot() {
        this.prepareData();
        IoTDB.metaManager.createMTreeSnapshot();
        try {
            MLogParser.parseFromFile((String)(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mtree-1.snapshot.bin"), (String)("target" + File.separator + "tmp" + File.separator + "text.snapshot"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.snapshot"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != 113) {
                for (String content : lines) {
                    logger.info(content);
                }
            }
            Assert.assertEquals((long)113L, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

