/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.manage.ISyncFileManager;
import org.apache.iotdb.db.sync.sender.manage.SyncFileManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.db.utils.SyncUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFileManagerTest {
    private static final Logger logger = LoggerFactory.getLogger(SyncFileManagerTest.class);
    private ISyncFileManager manager = SyncFileManager.getInstance();
    private SyncSenderConfig config = SyncSenderDescriptor.getInstance().getConfig();
    private String dataDir;

    @Before
    public void setUp() throws DiskSpaceInsufficientException {
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.config.update(this.dataDir);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testGetValidFiles() throws IOException, MetadataException {
        Set files;
        int i;
        HashMap<String, Map<Long, Map<Long, Set<File>>>> allFileList = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        Random r = new Random(0L);
        for (i = 0; i < 3; ++i) {
            IoTDB.metaManager.setStorageGroup(new PartialPath(this.getSgName(i)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                allFileList.computeIfAbsent(this.getSgName(i), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                String rand = r.nextInt(10000) + ".tsfile";
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + this.getSgName(i) + File.separator + "0" + File.separator + "0" + File.separator + rand;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(this.getSgName(i))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    logger.error("Can not create new file {}", (Object)file.getPath());
                }
                if (new File(file.getAbsolutePath() + ".resource").exists() || new File(file.getAbsolutePath() + ".resource").createNewFile()) continue;
                logger.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        this.manager.getValidFiles(this.dataDir);
        Assert.assertTrue((boolean)SyncUtils.isEmpty((Map)this.manager.getLastLocalFilesMap()));
        this.updateLastLocalFiles(allFileList);
        this.manager.getValidFiles(this.dataDir);
        Map lastFileMap = this.manager.getLastLocalFilesMap();
        this.assertFileMap(allFileList, lastFileMap);
        HashMap<String, Map<Long, Map<Long, Set<File>>>> correctToBeSyncedFiles = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        r = new Random(1L);
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 5; ++j) {
                allFileList.computeIfAbsent(this.getSgName(i2), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                correctToBeSyncedFiles.computeIfAbsent(this.getSgName(i2), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                String rand = r.nextInt(10000) + ".tsfile";
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + this.getSgName(i2) + File.separator + "0" + File.separator + "0" + File.separator + rand;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(this.getSgName(i2))).get(0L)).get(0L)).add(file);
                ((Set)((Map)((Map)correctToBeSyncedFiles.get(this.getSgName(i2))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    logger.error("Can not create new file {}", (Object)file.getPath());
                }
                if (new File(file.getAbsolutePath() + ".resource").exists() || new File(file.getAbsolutePath() + ".resource").createNewFile()) continue;
                logger.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        this.manager.getValidFiles(this.dataDir);
        Map curFileMap = this.manager.getCurrentSealedLocalFilesMap();
        Map toBeSyncedFilesMap = this.manager.getToBeSyncedFilesMap();
        this.assertFileMap(allFileList, curFileMap);
        this.assertFileMap(correctToBeSyncedFiles, toBeSyncedFilesMap);
        this.updateLastLocalFiles(allFileList);
        this.manager.getValidFiles(this.dataDir);
        lastFileMap = this.manager.getLastLocalFilesMap();
        this.assertFileMap(allFileList, lastFileMap);
        correctToBeSyncedFiles.clear();
        r = new Random(2L);
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j = 0; j < 5; ++j) {
                allFileList.computeIfAbsent(this.getSgName(i3), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                correctToBeSyncedFiles.computeIfAbsent(this.getSgName(i3), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                String rand = r.nextInt(10000) + ".tsfile";
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + this.getSgName(i3) + File.separator + "0" + File.separator + "0" + File.separator + File.separator + (String)rand;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(this.getSgName(i3))).get(0L)).get(0L)).add(file);
                ((Set)((Map)((Map)correctToBeSyncedFiles.get(this.getSgName(i3))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    logger.error("Can not create new file {}", (Object)file.getPath());
                }
                if (new File(file.getAbsolutePath() + ".resource").exists() || new File(file.getAbsolutePath() + ".resource").createNewFile()) continue;
                logger.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        int count = 0;
        HashMap<String, Map<Long, Map<Long, Set<File>>>> correctDeleteFile = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        for (Map.Entry entry : allFileList.entrySet()) {
            correctDeleteFile.put((String)entry.getKey(), new HashMap());
            for (Map.Entry vgEntry : ((Map)entry.getValue()).entrySet()) {
                ((Map)correctDeleteFile.get(entry.getKey())).putIfAbsent((Long)vgEntry.getKey(), new HashMap());
                for (Map.Entry innerEntry : ((Map)vgEntry.getValue()).entrySet()) {
                    files = (Set)innerEntry.getValue();
                    ((Map)((Map)correctDeleteFile.get(entry.getKey())).get(vgEntry.getKey())).putIfAbsent((Long)innerEntry.getKey(), new HashSet());
                    for (File file : files) {
                        if (++count % 3 != 0 || !((Set)((Map)((Map)lastFileMap.get(entry.getKey())).get(0L)).get(0L)).contains(file)) continue;
                        ((Set)((Map)((Map)correctDeleteFile.get(entry.getKey())).get(0L)).get(0L)).add(file);
                    }
                }
            }
        }
        for (Map.Entry entry : correctDeleteFile.entrySet()) {
            correctDeleteFile.put((String)entry.getKey(), new HashMap());
            for (Map.Entry vgEntry : ((Map)entry.getValue()).entrySet()) {
                ((Map)correctDeleteFile.get(entry.getKey())).putIfAbsent((Long)vgEntry.getKey(), new HashMap());
                for (Map.Entry innerEntry : ((Map)vgEntry.getValue()).entrySet()) {
                    files = (Set)innerEntry.getValue();
                    ((Map)((Map)correctDeleteFile.get(entry.getKey())).get(vgEntry.getKey())).putIfAbsent((Long)innerEntry.getKey(), new HashSet());
                    for (File file : (Set)innerEntry.getValue()) {
                        file.delete();
                        new File(file.getAbsolutePath() + ".resource").delete();
                        ((Set)((Map)((Map)allFileList.get(entry.getKey())).get(0L)).get(0L)).remove(file);
                    }
                }
            }
        }
        this.manager.getValidFiles(this.dataDir);
        curFileMap = this.manager.getCurrentSealedLocalFilesMap();
        Map deletedFilesMap = this.manager.getDeletedFilesMap();
        toBeSyncedFilesMap = this.manager.getToBeSyncedFilesMap();
        this.assertFileMap(allFileList, curFileMap);
        this.assertFileMap(correctDeleteFile, deletedFilesMap);
        this.assertFileMap(correctToBeSyncedFiles, toBeSyncedFilesMap);
        r = new Random(3L);
        for (int i4 = 0; i4 < 3; ++i4) {
            for (int j = 0; j < 5; ++j) {
                allFileList.computeIfAbsent(this.getSgName(i4), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                String rand = String.valueOf(r.nextInt(10000));
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + this.getSgName(i4) + File.separator + "0" + File.separator + "0" + File.separator + File.separator + rand;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(this.getSgName(i4))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists() || file.createNewFile()) continue;
                logger.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        this.manager.getValidFiles(this.dataDir);
        curFileMap = this.manager.getCurrentSealedLocalFilesMap();
        deletedFilesMap = this.manager.getDeletedFilesMap();
        toBeSyncedFilesMap = this.manager.getToBeSyncedFilesMap();
        this.assertFileMap(curFileMap, allFileList);
        this.assertFileMap(curFileMap, allFileList);
        this.assertFileMap(correctDeleteFile, deletedFilesMap);
        this.assertFileMap(correctToBeSyncedFiles, toBeSyncedFilesMap);
    }

    private void assertFileMap(Map<String, Map<Long, Map<Long, Set<File>>>> correctMap, Map<String, Map<Long, Map<Long, Set<File>>>> curMap) {
        for (Map.Entry<String, Map<Long, Map<Long, Set<File>>>> entry : correctMap.entrySet()) {
            Assert.assertTrue((boolean)curMap.containsKey(entry.getKey()));
            for (Map.Entry<Long, Map<Long, Set<File>>> innerEntry : entry.getValue().entrySet()) {
                Assert.assertTrue((boolean)curMap.get(entry.getKey()).containsKey(innerEntry.getKey()));
                for (Map.Entry<Long, Set<File>> fileEntry : innerEntry.getValue().entrySet()) {
                    Assert.assertTrue((boolean)curMap.get(entry.getKey()).get(innerEntry.getKey()).get(fileEntry.getKey()).containsAll((Collection)fileEntry.getValue()));
                }
            }
        }
    }

    private String getSgName(int i) {
        return "root." + i;
    }

    private void updateLastLocalFiles(Map<String, Map<Long, Map<Long, Set<File>>>> lastLocalFilesMap) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.config.getLastFileInfoPath())));){
            for (Map<Long, Map<Long, Set<File>>> currentLocalFiles : lastLocalFilesMap.values()) {
                for (Map<Long, Set<File>> vgFiles : currentLocalFiles.values()) {
                    for (Set<File> files : vgFiles.values()) {
                        for (File file : files) {
                            bw.write(file.getAbsolutePath());
                            bw.newLine();
                        }
                        bw.flush();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not clear sync log {}", (Object)this.config.getLastFileInfoPath(), (Object)e);
        }
    }
}

