/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.receiver.load.FileLoader;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderTest;
import org.apache.iotdb.db.sync.receiver.load.IFileLoader;
import org.apache.iotdb.db.sync.receiver.recover.ISyncReceiverLogAnalyzer;
import org.apache.iotdb.db.sync.receiver.recover.ISyncReceiverLogger;
import org.apache.iotdb.db.sync.receiver.recover.SyncReceiverLogAnalyzer;
import org.apache.iotdb.db.sync.receiver.recover.SyncReceiverLogger;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReceiverLogAnalyzerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoaderTest.class);
    private static final String SG_NAME = "root.sg";
    private String dataDir;
    private IFileLoader fileLoader;
    private ISyncReceiverLogAnalyzer logAnalyze;
    private ISyncReceiverLogger receiverLogger;

    @Before
    public void setUp() throws DiskSpaceInsufficientException, MetadataException {
        IoTDBDescriptor.getInstance().getConfig().setSyncEnable(true);
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.logAnalyze = SyncReceiverLogAnalyzer.getInstance();
        this.initMetadata();
    }

    private void initMetadata() throws MetadataException {
        MManager mmanager = IoTDB.metaManager;
        mmanager.init();
        mmanager.setStorageGroup(new PartialPath("root.sg0"));
        mmanager.setStorageGroup(new PartialPath("root.sg1"));
        mmanager.setStorageGroup(new PartialPath("root.sg2"));
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSyncEnable(false);
    }

    @Test
    public void recover() throws IOException, StorageEngineException, InterruptedException, IllegalPathException {
        int i;
        this.receiverLogger = new SyncReceiverLogger(new File(this.getReceiverFolderFile(), "sync.log"));
        this.fileLoader = FileLoader.createFileLoader((File)this.getReceiverFolderFile());
        HashMap allFileList = new HashMap();
        HashMap correctSequenceLoadedFileMap = new HashMap();
        Random r = new Random(0L);
        this.receiverLogger.startSyncTsFiles();
        HashSet<String> toBeSyncedFiles = new HashSet<String>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                allFileList.putIfAbsent(SG_NAME + i, new HashSet());
                correctSequenceLoadedFileMap.putIfAbsent(SG_NAME + i, new HashSet());
                String rand = String.valueOf(r.nextInt(10000) + i * j);
                String fileName = this.getSnapshotFolder() + File.separator + SG_NAME + i + File.separator + "0" + File.separator + "0" + File.separator + System.currentTimeMillis() + "-" + (String)rand + "-" + "0.tsfile";
                Thread.sleep(1L);
                File syncFile = new File(fileName);
                this.receiverLogger.finishSyncTsfile(syncFile);
                toBeSyncedFiles.add(syncFile.getAbsolutePath());
                File dataFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), syncFile.getParentFile().getName() + File.separatorChar + syncFile.getName());
                ((Set)correctSequenceLoadedFileMap.get(SG_NAME + i)).add(dataFile);
                ((Set)allFileList.get(SG_NAME + i)).add(syncFile);
                if (!syncFile.getParentFile().exists()) {
                    syncFile.getParentFile().mkdirs();
                }
                if (!syncFile.exists() && !syncFile.createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                if (!new File(syncFile.getAbsolutePath() + ".resource").exists() && !new File(syncFile.getAbsolutePath() + ".resource").createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                TsFileResource tsFileResource = new TsFileResource(syncFile);
                tsFileResource.updateStartTime(String.valueOf(i), (long)j * 10L);
                tsFileResource.updateEndTime(String.valueOf(i), (long)j * 10L + 5L);
                tsFileResource.serialize();
            }
        }
        for (i = 0; i < 3; ++i) {
            StorageGroupProcessor processor = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i));
            Assert.assertTrue((boolean)processor.getSequenceFileTreeSet().isEmpty());
            Assert.assertTrue((boolean)processor.getUnSequenceFileList().isEmpty());
        }
        Assert.assertTrue((boolean)this.getReceiverFolderFile().exists());
        for (Set set : allFileList.values()) {
            for (File newTsFile : set) {
                if (newTsFile.getName().endsWith(".resource")) continue;
                this.fileLoader.addTsfile(newTsFile);
            }
        }
        this.receiverLogger.close();
        Assert.assertTrue((boolean)new File(this.getReceiverFolderFile(), "load.log").exists());
        Assert.assertTrue((boolean)new File(this.getReceiverFolderFile(), "sync.log").exists());
        Assert.assertTrue((boolean)FileLoaderManager.getInstance().containsFileLoader(this.getReceiverFolderFile().getName()));
        int mode = 0;
        HashSet<String> toBeSyncedFilesTest = new HashSet<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.getReceiverFolderFile(), "sync.log")));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.equals("sync deleted file names start")) {
                    mode = -1;
                    continue;
                }
                if (line.equals("sync tsfile start")) {
                    mode = 1;
                    continue;
                }
                if (mode != 1) continue;
                toBeSyncedFilesTest.add(line);
            }
        }
        Assert.assertEquals((long)toBeSyncedFilesTest.size(), (long)toBeSyncedFiles.size());
        Assert.assertTrue((boolean)toBeSyncedFilesTest.containsAll(toBeSyncedFiles));
        this.logAnalyze.recover(this.getReceiverFolderFile().getName());
        try {
            long waitTime = 0L;
            while (FileLoaderManager.getInstance().containsFileLoader(this.getReceiverFolderFile().getName())) {
                Thread.sleep(100L);
                LOGGER.info("Has waited for loading new tsfiles {}ms", (Object)(waitTime += 100L));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Fail to wait for loading new tsfiles", (Throwable)e);
            Thread.currentThread().interrupt();
            throw e;
        }
        Assert.assertFalse((boolean)new File(this.getReceiverFolderFile(), "load.log").exists());
        Assert.assertFalse((boolean)new File(this.getReceiverFolderFile(), "sync.log").exists());
    }

    private File getReceiverFolderFile() {
        return new File(this.dataDir + File.separatorChar + "sync-receiver" + File.separatorChar + "127.0.0.1_5555");
    }

    private File getSnapshotFolder() {
        return new File(this.getReceiverFolderFile(), "data");
    }
}

