/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.HashVirtualPartitioner;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.receiver.load.FileLoader;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.load.IFileLoader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoaderTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoaderTest.class);
    private static final String SG_NAME = "root.sg";
    private String dataDir;
    private IFileLoader fileLoader;
    private CompactionStrategy compactionStrategy;

    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setSyncEnable(true);
        this.compactionStrategy = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        HashVirtualPartitioner.getInstance().setStorageGroupNum(1);
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.initMetadata();
    }

    private void initMetadata() throws MetadataException {
        MManager mmanager = IoTDB.metaManager;
        mmanager.init();
        mmanager.setStorageGroup(new PartialPath("root.sg0"));
        mmanager.setStorageGroup(new PartialPath("root.sg1"));
        mmanager.setStorageGroup(new PartialPath("root.sg2"));
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSyncEnable(false);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(this.compactionStrategy);
        HashVirtualPartitioner.getInstance().setStorageGroupNum(IoTDBDescriptor.getInstance().getConfig().getVirtualStorageGroupNum());
    }

    @Test
    public void loadNewTsfiles() throws IOException, StorageEngineException, IllegalPathException, InterruptedException {
        int i;
        this.fileLoader = FileLoader.createFileLoader((File)this.getReceiverFolderFile());
        HashMap allFileList = new HashMap();
        HashMap correctSequenceLoadedFileMap = new HashMap();
        Random r = new Random(0L);
        long time = System.currentTimeMillis();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                allFileList.putIfAbsent(SG_NAME + i, new ArrayList());
                correctSequenceLoadedFileMap.putIfAbsent(SG_NAME + i, new HashSet());
                String rand = String.valueOf(r.nextInt(10000));
                String fileName = this.getSnapshotFolder() + File.separator + SG_NAME + i + File.separator + "0" + File.separator + "0" + File.separator + (time + (long)(i * 100) + (long)j) + "-" + (String)rand + "-" + "0-0.tsfile";
                File syncFile = new File(fileName);
                File dataFile = new File(syncFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "sequence" + File.separatorChar + syncFile.getParentFile().getParentFile().getName() + File.separatorChar + syncFile.getParentFile().getName() + File.separatorChar + this.fromTimeToTimePartition(i) + File.separator + syncFile.getName());
                ((Set)correctSequenceLoadedFileMap.get(SG_NAME + i)).add(dataFile.getAbsolutePath());
                ((List)allFileList.get(SG_NAME + i)).add(syncFile);
                if (!syncFile.getParentFile().exists()) {
                    syncFile.getParentFile().mkdirs();
                }
                if (!syncFile.exists() && !syncFile.createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                if (!new File(syncFile.getAbsolutePath() + ".resource").exists() && !new File(syncFile.getAbsolutePath() + ".resource").createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                TsFileResource tsFileResource = new TsFileResource(syncFile);
                tsFileResource.updateStartTime(String.valueOf(i), (long)j * 10L);
                tsFileResource.updateEndTime(String.valueOf(i), (long)j * 10L + 5L);
                tsFileResource.setMaxPlanIndex((long)j);
                tsFileResource.setMinPlanIndex((long)j);
                tsFileResource.serialize();
            }
        }
        for (i = 0; i < 3; ++i) {
            StorageGroupProcessor processor = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i));
            Assert.assertTrue((boolean)processor.getSequenceFileTreeSet().isEmpty());
            Assert.assertTrue((boolean)processor.getUnSequenceFileList().isEmpty());
        }
        Assert.assertTrue((boolean)this.getReceiverFolderFile().exists());
        for (List set : allFileList.values()) {
            for (Object newTsFile : set) {
                if (((File)newTsFile).getName().endsWith(".resource")) continue;
                this.fileLoader.addTsfile((File)newTsFile);
            }
        }
        this.fileLoader.endSync();
        try {
            long waitTime = 0L;
            while (FileLoaderManager.getInstance().containsFileLoader(this.getReceiverFolderFile().getName())) {
                Thread.sleep(100L);
                LOGGER.info("Has waited for loading new tsfiles {}ms", (Object)(waitTime += 100L));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Fail to wait for loading new tsfiles", (Throwable)e);
            Thread.currentThread().interrupt();
            throw e;
        }
        Assert.assertFalse((boolean)new File(this.getReceiverFolderFile(), "data").exists());
        HashMap sequenceLoadedFileMap = new HashMap();
        for (int i2 = 0; i2 < 3; ++i2) {
            StorageGroupProcessor processor = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i2));
            sequenceLoadedFileMap.putIfAbsent(SG_NAME + i2, new HashSet());
            Assert.assertEquals((long)10L, (long)processor.getSequenceFileTreeSet().size());
            for (TsFileResource tsFileResource : processor.getSequenceFileTreeSet()) {
                ((Set)sequenceLoadedFileMap.get(SG_NAME + i2)).add(tsFileResource.getTsFile().getAbsolutePath());
            }
            Assert.assertTrue((boolean)processor.getUnSequenceFileList().isEmpty());
        }
        Assert.assertEquals((long)sequenceLoadedFileMap.size(), (long)correctSequenceLoadedFileMap.size());
        for (Map.Entry entry : correctSequenceLoadedFileMap.entrySet()) {
            String sg = (String)entry.getKey();
            Assert.assertEquals((long)((Set)entry.getValue()).size(), (long)((Set)sequenceLoadedFileMap.get(sg)).size());
        }
    }

    @Test
    public void loadDeletedFileName() throws IOException, StorageEngineException, InterruptedException, IllegalPathException {
        Object sg;
        StorageGroupProcessor processor;
        int i;
        this.fileLoader = FileLoader.createFileLoader((File)this.getReceiverFolderFile());
        HashMap allFileList = new HashMap();
        HashMap correctLoadedFileMap = new HashMap();
        Random r = new Random(0L);
        long time = System.currentTimeMillis();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 25; ++j) {
                allFileList.putIfAbsent(SG_NAME + i, new ArrayList());
                correctLoadedFileMap.putIfAbsent(SG_NAME + i, new HashSet());
                String rand = String.valueOf(r.nextInt(10000));
                String fileName = this.getSnapshotFolder() + File.separator + SG_NAME + i + File.separator + "0" + File.separator + "0" + File.separator + (time + (long)(i * 100) + (long)j) + "-" + (String)rand + "-" + "0-0.tsfile";
                File syncFile = new File(fileName);
                File dataFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), syncFile.getParentFile().getName() + File.separator + syncFile.getName());
                File loadDataFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), syncFile.getParentFile().getParentFile().getParentFile().getName() + File.separator + "0" + File.separator + this.fromTimeToTimePartition(i) + File.separator + syncFile.getName());
                ((Set)correctLoadedFileMap.get(SG_NAME + i)).add(loadDataFile.getAbsolutePath());
                ((List)allFileList.get(SG_NAME + i)).add(syncFile);
                if (!syncFile.getParentFile().exists()) {
                    syncFile.getParentFile().mkdirs();
                }
                if (!syncFile.exists() && !syncFile.createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                if (!new File(syncFile.getAbsolutePath() + ".resource").exists() && !new File(syncFile.getAbsolutePath() + ".resource").createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)syncFile.getPath());
                }
                TsFileResource tsFileResource = new TsFileResource(syncFile);
                tsFileResource.updateStartTime(String.valueOf(i), (long)j * 10L);
                tsFileResource.updateEndTime(String.valueOf(i), (long)j * 10L + 5L);
                tsFileResource.setMinPlanIndex((long)j);
                tsFileResource.setMaxPlanIndex((long)j);
                tsFileResource.serialize();
            }
        }
        for (i = 0; i < 3; ++i) {
            StorageGroupProcessor processor2 = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i));
            Assert.assertTrue((boolean)processor2.getSequenceFileTreeSet().isEmpty());
            Assert.assertTrue((boolean)processor2.getUnSequenceFileList().isEmpty());
        }
        Assert.assertTrue((boolean)this.getReceiverFolderFile().exists());
        for (List set : allFileList.values()) {
            for (Object newTsFile : set) {
                if (((File)newTsFile).getName().endsWith(".resource")) continue;
                this.fileLoader.addTsfile((File)newTsFile);
            }
        }
        this.fileLoader.endSync();
        try {
            long waitTime = 0L;
            while (FileLoaderManager.getInstance().containsFileLoader(this.getReceiverFolderFile().getName())) {
                Thread.sleep(100L);
                LOGGER.info("Has waited for loading new tsfiles {}ms", (Object)(waitTime += 100L));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Fail to wait for loading new tsfiles", (Throwable)e);
            Thread.currentThread().interrupt();
            throw e;
        }
        Assert.assertFalse((boolean)new File(this.getReceiverFolderFile(), "data").exists());
        HashMap loadedFileMap = new HashMap();
        for (int i2 = 0; i2 < 3; ++i2) {
            processor = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i2));
            loadedFileMap.putIfAbsent(SG_NAME + i2, new HashSet());
            Assert.assertEquals((long)25L, (long)processor.getSequenceFileTreeSet().size());
            for (TsFileResource tsFileResource : processor.getSequenceFileTreeSet()) {
                ((Set)loadedFileMap.get(SG_NAME + i2)).add(tsFileResource.getTsFile().getAbsolutePath());
            }
            Assert.assertTrue((boolean)processor.getUnSequenceFileList().isEmpty());
        }
        Assert.assertEquals((long)loadedFileMap.size(), (long)correctLoadedFileMap.size());
        for (Map.Entry entry : correctLoadedFileMap.entrySet()) {
            sg = (String)entry.getKey();
            Assert.assertEquals((long)((Set)entry.getValue()).size(), (long)((Set)loadedFileMap.get(sg)).size());
        }
        this.fileLoader = FileLoader.createFileLoader((File)this.getReceiverFolderFile());
        block13: for (Map.Entry entry : allFileList.entrySet()) {
            sg = (String)entry.getKey();
            List files = (List)entry.getValue();
            int cnt = 0;
            for (File snapFile : files) {
                if (snapFile.getName().endsWith(".resource")) continue;
                File dataFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile() + File.separator + snapFile.getParentFile().getParentFile().getParentFile().getName(), "0" + File.separator + "0" + File.separator + snapFile.getName());
                ((Set)correctLoadedFileMap.get(sg)).remove(dataFile.getAbsolutePath());
                snapFile.delete();
                this.fileLoader.addDeletedFileName(snapFile);
                new File(snapFile + ".resource").delete();
                if (++cnt != 15) continue;
                continue block13;
            }
        }
        this.fileLoader.endSync();
        try {
            long waitTime = 0L;
            while (FileLoaderManager.getInstance().containsFileLoader(this.getReceiverFolderFile().getName())) {
                Thread.sleep(100L);
                LOGGER.info("Has waited for loading new tsfiles {}ms", (Object)(waitTime += 100L));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Fail to wait for loading new tsfiles", (Throwable)e);
            Thread.currentThread().interrupt();
            throw e;
        }
        loadedFileMap.clear();
        for (int i3 = 0; i3 < 3; ++i3) {
            processor = StorageEngine.getInstance().getProcessor(new PartialPath(SG_NAME + i3));
            loadedFileMap.putIfAbsent(SG_NAME + i3, new HashSet());
            for (TsFileResource tsFileResource : processor.getSequenceFileTreeSet()) {
                ((Set)loadedFileMap.get(SG_NAME + i3)).add(tsFileResource.getTsFile().getAbsolutePath());
            }
            Assert.assertTrue((boolean)processor.getUnSequenceFileList().isEmpty());
        }
        Assert.assertEquals((long)loadedFileMap.size(), (long)correctLoadedFileMap.size());
        for (Map.Entry entry : correctLoadedFileMap.entrySet()) {
            sg = (String)entry.getKey();
            Assert.assertEquals((long)((Set)entry.getValue()).size(), (long)((Set)loadedFileMap.get(sg)).size());
            Assert.assertTrue((boolean)((Set)entry.getValue()).containsAll((Collection)loadedFileMap.get(sg)));
        }
    }

    private File getReceiverFolderFile() {
        return new File(this.dataDir + File.separatorChar + "sync-receiver" + File.separatorChar + "127.0.0.1_5555");
    }

    private File getSnapshotFolder() {
        return new File(this.getReceiverFolderFile(), "data");
    }

    private long fromTimeToTimePartition(long time) {
        return time / IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
    }
}

