/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnvScriptIT {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            this.testStartClientOnWindows(".bat", os);
        } else {
            this.testStartClientOnUnix(".sh", os);
        }
    }

    private void testStartClientOnWindows(String suffix, String os) throws IOException {
        String dir = this.getServerPath();
        String output = "If you want to change this configuration, please check conf/iotdb-env.sh(Unix or OS X, if you use Windows, check conf/iotdb-env.bat).";
        String cmd = dir + File.separator + "conf" + File.separator + "iotdb-env" + suffix;
        ProcessBuilder startBuilder = new ProcessBuilder("cmd.exe", "/c", cmd);
        this.testOutput(dir, suffix, startBuilder, "If you want to change this configuration, please check conf/iotdb-env.sh(Unix or OS X, if you use Windows, check conf/iotdb-env.bat).", os);
    }

    private void testStartClientOnUnix(String suffix, String os) throws IOException {
        String dir = this.getServerPath();
        String output = "If you want to change this configuration, please check conf/iotdb-env.sh(Unix or OS X, if you use Windows, check conf/iotdb-env.bat).";
        String cmd = dir + File.separator + "conf" + File.separator + "iotdb-env" + suffix;
        ProcessBuilder builder = new ProcessBuilder("bash", cmd);
        this.testOutput(cmd, suffix, builder, "If you want to change this configuration, please check conf/iotdb-env.sh(Unix or OS X, if you use Windows, check conf/iotdb-env.bat).", os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOutput(String cmd, String suffix, ProcessBuilder builder, String output, String os) throws IOException {
        builder.redirectErrorStream(true);
        Process startProcess = builder.start();
        BufferedReader startReader = new BufferedReader(new InputStreamReader(startProcess.getInputStream()));
        ArrayList<String> runtimeOuput = new ArrayList<String>();
        try {
            String line;
            while ((line = startReader.readLine()) != null) {
                runtimeOuput.add(line);
            }
            Assert.assertEquals((Object)output, runtimeOuput.get(runtimeOuput.size() - 1));
        }
        finally {
            startReader.close();
            startProcess.destroy();
            runtimeOuput.clear();
        }
    }

    private String getCurrentPath(String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String path = r.readLine();
        return path;
    }

    protected String getServerPath() {
        File userDir = new File(System.getProperty("user.dir"));
        if (!userDir.exists()) {
            throw new RuntimeException("user.dir " + userDir.getAbsolutePath() + " doesn't exist.");
        }
        File target = new File(userDir, "target/maven-archiver/pom.properties");
        Properties properties = new Properties();
        Assert.assertTrue((boolean)target.exists());
        try {
            properties.load(new FileReader(target));
        }
        catch (IOException e) {
            return "target/iotdb-server-";
        }
        return new File(userDir, String.format("target/%s-%s", properties.getProperty("artifactId"), properties.getProperty("version"))).getAbsolutePath();
    }
}

