/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.RowIterator;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingTimeWindowConstructionTester
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(SlidingTimeWindowConstructionTester.class);

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("SlidingTimeWindowConstructionTester#beforeStart");
        long timeInterval = parameters.getLong("timeInterval");
        configurations.setOutputDataType(TSDataType.INT32).setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy(timeInterval));
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException {
        int accumulator = 0;
        RowIterator rowIterator = rowWindow.getRowIterator();
        while (rowIterator.hasNextRow()) {
            accumulator += rowIterator.next().getInt(0);
        }
        if (rowWindow.windowSize() != 0) {
            collector.putInt(rowWindow.getRow(0).getTime(), accumulator);
        }
    }

    public void beforeDestroy() {
        logger.debug("SlidingTimeWindowConstructionTester#beforeDestroy");
    }
}

