/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingSizeWindowConstructorTester1
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(SlidingSizeWindowConstructorTester1.class);
    private int consumptionPoint;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("SlidingSizeWindowConstructorTester1#beforeStart");
        this.consumptionPoint = parameters.getInt("consumptionPoint");
        configurations.setOutputDataType(TSDataType.INT32).setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.getTime() == (long)this.consumptionPoint) {
            collector.putInt(row.getTime(), row.getInt(0));
        }
    }

    public void beforeDestroy() {
        logger.debug("SlidingSizeWindowConstructorTester1#beforeDestroy");
    }
}

