/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Max
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Max.class);
    private Long time;
    private int value;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Max#beforeStart");
        configurations.setOutputDataType(TSDataType.INT32).setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
    }

    public void transform(Row row, PointCollector collector) {
        int candidateValue = row.getInt(0);
        if (this.time == null || this.value < candidateValue) {
            this.time = row.getTime();
            this.value = candidateValue;
        }
    }

    public void terminate(PointCollector collector) throws IOException {
        if (this.time != null) {
            collector.putInt(this.time.longValue(), this.value);
        }
    }

    public void beforeDestroy() {
        logger.debug("Max#beforeDestroy");
    }
}

