/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Counter
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Counter.class);

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Counter#beforeStart");
        configurations.setOutputDataType(TSDataType.INT32);
        switch (parameters.getStringOrDefault("access", "row-by-row")) {
            case "size": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(parameters.getInt("windowSize").intValue()));
                break;
            }
            case "time": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy(parameters.getLong("timeInterval").longValue(), parameters.getLong("slidingStep").longValue(), parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue()));
                break;
            }
            default: {
                configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
            }
        }
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putInt(row.getTime(), 1);
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() != 0) {
            collector.putInt(rowWindow.getRow(0).getTime(), rowWindow.windowSize());
        }
    }

    public void beforeDestroy() {
        logger.debug("Counter#beforeDestroy");
    }
}

