/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowIterator;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accumulator
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Accumulator.class);

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Accumulator#beforeStart");
        configurations.setOutputDataType(TSDataType.INT32);
        switch (parameters.getStringOrDefault("access", "row-by-row")) {
            case "size": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(parameters.getInt("windowSize").intValue()));
                break;
            }
            case "time": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy(parameters.getLong("timeInterval").longValue(), parameters.getLong("slidingStep").longValue(), parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue()));
                break;
            }
            default: {
                configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
            }
        }
    }

    public void transform(Row row, PointCollector collector) throws IOException {
        collector.putInt(row.getTime(), row.getInt(0));
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException {
        int accumulator = 0;
        RowIterator rowIterator = rowWindow.getRowIterator();
        while (rowIterator.hasNextRow()) {
            accumulator += rowIterator.next().getInt(0);
        }
        if (rowWindow.windowSize() != 0) {
            collector.putInt(rowWindow.getRow(0).getTime(), accumulator);
        }
    }

    public void beforeDestroy() {
        logger.debug("Accumulator#beforeDestroy");
    }
}

