/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.io.IOException;
import java.util.Random;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.db.query.udf.datastructure.SerializableListTest;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSerializableTVListTest
extends SerializableListTest {
    private ElasticSerializableTVList tvList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testESIntTVList() {
        this.testESTVList(TSDataType.INT32);
    }

    @Test
    public void testESLongTVList() {
        this.testESTVList(TSDataType.INT64);
    }

    @Test
    public void testESFloatTVList() {
        this.testESTVList(TSDataType.FLOAT);
    }

    @Test
    public void testESDoubleTVList() {
        this.testESTVList(TSDataType.DOUBLE);
    }

    @Test
    public void testESTextTVList() {
        this.testESTVList(TSDataType.TEXT);
    }

    @Test
    public void testESBooleanTVList() {
        this.testESTVList(TSDataType.BOOLEAN);
    }

    private void testESTVList(TSDataType dataType) {
        this.initESTVList(dataType);
        this.testPut(dataType);
        this.testOrderedAccessByIndex(dataType);
    }

    private void initESTVList(TSDataType dataType) {
        try {
            this.tvList = ElasticSerializableTVList.newElasticSerializableTVList((TSDataType)dataType, (long)0L, (float)100.0f, (int)3);
        }
        catch (QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertEquals((long)0L, (long)this.tvList.size());
    }

    private void testPut(TSDataType dataType) {
        try {
            switch (dataType) {
                case INT32: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putInt((long)i, i);
                    }
                    break;
                }
                case INT64: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putLong((long)i, (long)i);
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putFloat((long)i, (float)i);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putDouble((long)i, (double)i);
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putBoolean((long)i, i % 2 == 0);
                    }
                    break;
                }
                case TEXT: {
                    for (int i = 0; i < 10000; ++i) {
                        this.tvList.putBinary((long)i, Binary.valueOf((String)String.valueOf(i)));
                    }
                    break;
                }
            }
        }
        catch (IOException | QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertEquals((long)10000L, (long)this.tvList.size());
    }

    private void testOrderedAccessByIndex(TSDataType dataType) {
        try {
            switch (dataType) {
                case INT32: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((long)i, (long)this.tvList.getInt(i));
                    }
                    break;
                }
                case INT64: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((long)i, (long)this.tvList.getLong(i));
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((float)i, (float)this.tvList.getFloat(i), (float)0.0f);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((double)i, (double)this.tvList.getDouble(i), (double)0.0);
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)this.tvList.getBoolean(i));
                    }
                    break;
                }
                case TEXT: {
                    for (int i = 0; i < 10000; ++i) {
                        Assert.assertEquals((long)i, (long)this.tvList.getTime(i));
                        Assert.assertEquals((Object)Binary.valueOf((String)String.valueOf(i)), (Object)this.tvList.getBinary(i));
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMemoryControl() {
        this.initESTVList(TSDataType.TEXT);
        int byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 2;
        int byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 8;
        Random random = new Random();
        try {
            int i;
            int length;
            for (int i2 = 0; i2 < 10000; ++i2) {
                this.tvList.putBinary((long)i2, Binary.valueOf((String)this.generateRandomString(byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin))));
            }
            LayerPointReader reader = this.tvList.getPointReaderUsingEvictionStrategy();
            while (reader.next()) {
                length = reader.currentBinary().getLength();
                Assert.assertTrue((byteLengthMin <= length && length < byteLengthMax ? 1 : 0) != 0);
                reader.readyForNext();
            }
            byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 16;
            byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 32;
            for (i = 0; i < 10000; ++i) {
                this.tvList.putBinary((long)i, Binary.valueOf((String)this.generateRandomString(byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin))));
            }
            while (reader.next()) {
                length = reader.currentBinary().getLength();
                Assert.assertTrue((byteLengthMin <= length && length < byteLengthMax ? 1 : 0) != 0);
                reader.readyForNext();
            }
            byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 256;
            byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 512;
            for (i = 0; i < 10000; ++i) {
                this.tvList.putBinary((long)i, Binary.valueOf((String)this.generateRandomString(byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin))));
            }
            while (reader.next()) {
                length = reader.currentBinary().getLength();
                Assert.assertTrue((byteLengthMin <= length && length < byteLengthMax ? 1 : 0) != 0);
                reader.readyForNext();
            }
            for (i = 0; i < 20000; ++i) {
                this.tvList.putBinary((long)i, Binary.valueOf((String)this.generateRandomString(byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin))));
                reader.next();
                int length2 = reader.currentBinary().getLength();
                Assert.assertTrue((byteLengthMin <= length2 && length2 < byteLengthMax ? 1 : 0) != 0);
                reader.readyForNext();
            }
            Assert.assertEquals((long)50000L, (long)this.tvList.size());
        }
        catch (IOException | QueryProcessException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private String generateRandomString(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

